#' ED patients and welfare
#'
#' Welfare distribution and emergency department (ED) patients.
#' 
#' @docType data
#' 
#' @keywords datasets
#'
#' @format A data frame with 30 rows (one per person) and 2 columns:
#' \describe{
#'   \item{Days}{The number of days after welfare distribution}
#'   \item{ED}{The mean number of emergency department (ED) patients}
#' }
#' @source 
#' Data read from the scatterplot in 
#' Brunette, Douglas D., John Kominsky, and Ernest Ruiz. 1991. 
#' Correlation of Emergency Health Care Use, 911 Volume, 
#' and Jail Activity with Welfare Check Distribution.
#' \emph{Annals of Emergency Medicine} \bold{20} (7): 739--42.
#' 
#' @usage 
#' data(EDpatients)
#' 
#' @examples
#' plot(ED ~ Days, data = EDpatients, xlab = "Days after welfare distribution", ylab = "Mean ED patients")
#' 

"EDpatients"
