% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/figures.R
\name{plotFunctions}
\alias{plotFunctions}
\title{Heatmap of the most abundant functions in a SQM object}
\usage{
plotFunctions(
  SQM,
  fun_level = "KEGG",
  count = "copy_number",
  N = 25,
  fun = NULL,
  samples = NULL,
  display_function_names = TRUE,
  ignore_unmapped = TRUE,
  ignore_unclassified = TRUE,
  gradient_col = c("ghostwhite", "dodgerblue4"),
  rescale_percent = FALSE,
  base_size = 11,
  metadata_groups = NULL
)
}
\arguments{
\item{SQM}{A SQM, SQMbunch or SQMlite object.}

\item{fun_level}{character. Either \code{"KEGG"}, \code{"COG"}, \code{"PFAM"} or any other custom database used for annotation (default \code{"KEGG"}).}

\item{count}{character. Either \code{"abund"} for raw abundances, \code{"percent"} for percentages, \code{"bases"} for raw base counts, \code{"cpm"} for coverages per million reads, \code{"tpm"} for TPM normalized values or \code{"copy_number"} for copy numbers (default \code{"tpm"}). Note that a given count type might not available in this object (e.g. TPM or copy number in SQMlite objects originating from a SQM reads project).}

\item{N}{integer Plot the \code{N} most abundant functions (default \code{25}).}

\item{fun}{character. Custom functions to plot. If provided, it will override \code{N} (default \code{NULL}).}

\item{samples}{character. Character vector with the names of the samples to include in the plot. Can also be used to plot the samples in a custom order. If not provided, all samples will be plotted (default \code{NULL}).}

\item{display_function_names}{logical. Plot function names alongside function IDs, if available (default \code{TRUE}).}

\item{ignore_unmapped}{logical. Don't include unmapped reads in the plot (default \code{TRUE}).}

\item{ignore_unclassified}{logical. Don't include unclassified ORFs in the plot (default \code{TRUE}).}

\item{gradient_col}{A vector of two colors representing the low and high ends of the color gradient (default \code{c("ghostwhite", "dodgerblue4")}).}

\item{rescale_percent}{logical. Calculate percent counts over the number of reads in the input object, instead of over the total number of reads in the original project (default \code{FALSE}).}

\item{base_size}{numeric. Base font size (default \code{11}).}

\item{metadata_groups}{list. Split the plot into groups defined by the user: list('G1' = c('sample1', sample2'), 'G2' = c('sample3', 'sample4')) default \code{NULL}).}
}
\value{
a ggplot2 plot object.
}
\description{
This function selects the most abundant functions across all samples in a SQM object and represents their abundances in a heatmap. Alternatively, a custom set of functions can be represented.
}
\examples{
data(Hadza)
plotFunctions(Hadza)
}
\seealso{
\code{\link{plotTaxonomy}} for plotting the most abundant taxa of a SQM object; \code{\link{plotBars}} and \code{\link{plotHeatmap}} for plotting barplots or heatmaps with arbitrary data.
}
