% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msi.dataset_methods.R
\docType{methods}
\name{getShapeMSI,msi.dataset-method}
\alias{getShapeMSI,msi.dataset-method}
\alias{getShapeMSI}
\title{Returns the geometrical shape of MS image}
\usage{
\S4method{getShapeMSI}{msi.dataset}(object)
}
\arguments{
\item{object}{\link{msi.dataset-class} object.}
}
\value{
number of rows ans number of columns of the MS image.
}
\description{
Returns the geometrical shape of MS image
}
\examples{
## Load package
library("SPUTNIK")

## Create the msi.dataset-class object
sz <- c(5, 4)
x <- matrix(rnorm(sz[1] * sz[2]), sz[1], sz[2])
mz <- seq(100, 195, 5)
msiX <- msiDataset(x, mz, sz[1], sz[2])

## Get m/z vector
mz <- getMZ(msiX)

## Get intensity matrix
X <- getIntensityMat(msiX)

## Get image size
sz <- getShapeMSI(msiX)
}
