% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createFolds.SPQR.R
\name{createFolds.SPQR}
\alias{createFolds.SPQR}
\title{generate cross-validation folds}
\usage{
createFolds.SPQR(Y, nfold, stratified = FALSE)
}
\arguments{
\item{Y}{The response vector.}

\item{nfold}{The number of cross-validation folds.}

\item{stratified}{If \code{TRUE}, stratified folds based on quantiles of \code{Y} are generated.}
}
\value{
A list of size \code{nfold} containing indices of the observations for each fold.
}
\description{
Helper function to generate cross-validation folds that can be used by \code{cv.SPQR}.
}
\examples{
set.seed(919)
n <- 1000
X <- rbinom(n, 1, 0.5)
Y <- rnorm(n, X, 0.8)
folds <- createFolds.SPQR(Y, nfold = 5)

}
