% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funKerasModular.R
\name{prepareProgressPlot}
\alias{prepareProgressPlot}
\title{prepare data frame for progress plot}
\usage{
prepareProgressPlot(modelList, runNr, directory, maxY = NULL)
}
\arguments{
\item{modelList}{ml/dl model (character)}

\item{runNr}{run number (character)}

\item{directory}{location of the (non-default, e.g., tuned) parameter file}

\item{maxY}{max number of y values. If \code{NULL} then all y values are used.}
}
\value{
data frame with results:
\describe{
	\item{\code{x}}{integer representing step}
	\item{\code{y}}{corresponding function value at step x.}
	\item{\code{name}}{ml/dl model name, e.g., ranger}
	\item{\code{size}}{initial design size.}
	\item{\code{yInitMin}}{min y value before SMBO is started, based on the
	initial design only.}
}
}
\description{
converts \code{result} from a \code{\link[SPOT]{spot}} run into the long format.
}
\examples{
\donttest{
modelList <- list("dl")
runNr <- list("28")
directory <- "../book/data"
prepareProgressPlot(modelList,
                    runNr,
                    directory)
}
}
