% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelMarkovChain.R
\name{plotPrediction}
\alias{plotPrediction}
\title{plotPrediction}
\usage{
plotPrediction(regionDf, countryIndex = 1, ylog = FALSE)
}
\arguments{
\item{regionDf}{A list containing a representation of the data.}

\item{countryIndex}{num Index}

\item{ylog}{logical plot log y axis (log = y)}
}
\value{
A plot
}
\description{
plot predictions countries/regions by index
}
\examples{
\dontrun{
require(SPOT)
data <- preprocessInputData(regionTrain, regionPopulation)
testData <- preprocessTestData(regionTest)
# Select the first region:
testData <- testData[testData$Region==levels(testData$Region)[1], ]
testData$Region <- droplevels(testData$Region)
# Very small number of function evaluations:
n <- 6
res <- lapply(data[1], tuneRegionModel, pops=NULL, 
              control=list(funEvals=n, designControl=list(size=5), model = buildLM))
parsedList <- parseTunedRegionModel(res)
pred <- generateMCPrediction(testData = testData, models = parsedList$models, write = FALSE)
quickPredict <- cbind(pred, testData$Date, testData$Region)
names(quickPredict) <- c("ForecastID", "confirmed", "fatalities", "date", "region")
p <- plotPrediction(quickPredict, 1)
}
}
