% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spotSurf.R
\name{spotSurf3d}
\alias{spotSurf3d}
\title{spotSurf3d}
\usage{
spotSurf3d(f = function(x) {     rowSums(x^2) }, lo = c(0, 0), up = c(1,
  1), s = 100, clip = c(NA, NA), points, ...)
}
\arguments{
\item{f}{function to be plotted. The function should either be able to take two vectors or one matrix specifying sample locations. i.e. \code{z=f(X)} or \code{z=f(x2,x1)} where Z is a two column matrix containing the sample locations \code{x1} and \code{x2}.}

\item{lo}{lower boundary for x1 and x2 (defaults to \code{c(0,0)}).}

\item{up}{upper boundary (defaults to \code{c(1,1)}).}

\item{s}{number of samples along each dimension. e.g. \code{f} will be evaluated \code{s^2} times.}

\item{clip}{\code{z} values smaller than \code{clip[1]} and larger than \code{clip[2]} are set to \code{NA}, to prevent them being visible in the plot. May result in ragged plots, but controls scaling.}

\item{points}{can be omitted, but if given the points in this matrix are added to the plot}

\item{...}{additional parameters passed to \code{f}}
}
\description{
Simple surface plot in three dimensions, using the rgl package with persp3 to plot.
}
\examples{
spotSurf3d(function(x){apply(x,1,spotBraninFunction)},c(-5,0),c(10,15))

}
\seealso{
\code{\link{spotSurfContour}}
}

