% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spotGaussianLandscapeGenerator.R
\name{spotGlgInitN}
\alias{spotGlgInitN}
\title{Initialize Gaussian Landscape (multiple)}
\usage{
spotGlgInitN(oDimension = 2, iDimension = 2, nGaussian = rep(10,
  oDimension), lower = rep(0, iDimension), upper = rep(1, iDimension),
  globalvalue = rep(1, oDimension), ratio = rep(0.8, oDimension),
  seed = 1)
}
\arguments{
\item{oDimension}{dimensionality of output, i.e. number of landscapes. Default is 2.}

\item{iDimension}{dimensionality of the landscapes input space. Default is 2.}

\item{nGaussian}{number of Gaussian components in the landscape. Default is 10.}

\item{lower}{lower boundary of the landscape, defaults to \code{rep(0,dimension)}.}

\item{upper}{upper boundary of the landscape, defaults to \code{rep(1,dimension)}.}

\item{globalvalue}{the global maximum value, i.e. the maximum of the Gaussian component with the largest value. Default is 1.}

\item{ratio}{maximum ratio of the local maxima, local optima are randomly generated within \code{[0,globalvalue*ratio]}. Has to be larger than 0 and smaller than 1. Defaults to 0.8.}

\item{seed}{seed for the random number generator used before creation of the landscape. Generator status will be saved and reset afterwards.}
}
\value{
returns a list containing again lists for each landscape,
 containing with the following items:\cr
\code{mean} Matrix containing the mean vectors of the Gaussian components in the landscape, i.e. the locations of the local maxima of the functions. First vector (i.e. first row) will be the global maximum.
\code{covinv} Inverse of covariance matrix of each Gaussian component, stored as 3-dimensional array.
\code{opt} optimal values, i.e. maxima of the Gaussian components
\code{ngauss} number of Gaussian components
\code{d} is the \code{dimension}
}
\description{
This function is based on the Gaussian Landscape Generator by Bo Yuan and Marcus Gallagher.
It randomly initializes multiple Gaussian Landscapes with the specified parameters.
Does not have to be called by user, if \code{\link{spotGlgCreateN}} is used.
}
\references{
B. Yuan and M. Gallagher (2003) "On Building a Principled Framework for Evaluating and Testing Evolutionary Algorithms: A Continuous Landscape Generator". 
In Proceedings of the 2003 Congress on Evolutionary Computation, IEEE, pp. 451-458, Canberra, Australia.
}
\seealso{
\code{\link{spotGlgCreateN}}, \code{\link{spotGlgEvalN}}, \code{\link{spotGlgInit}}
}

