% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/spotGaussianLandscapeGenerator.R
\name{spotGlgCreateRot}
\alias{spotGlgCreateRot}
\title{Create Gaussian Landscape (rotated)}
\usage{
spotGlgCreateRot(iDimension = 2, alpha = pi/2, nGaussian = 10,
  lower = rep(0, iDimension), upper = rep(1, iDimension), globalvalue = 1,
  ratio = 0.8, seed = 1)
}
\arguments{
\item{iDimension}{dimensionality of the landscapes input space. Default is 2.}

\item{alpha}{rotation angle. Default is pi/2.}

\item{nGaussian}{number of Gaussian components in the landscape. Default is 10.}

\item{lower}{lower boundary of the landscape, defaults to \code{rep(0,dimension)}.}

\item{upper}{upper boundary of the landscape, defaults to \code{rep(1,dimension)}.}

\item{globalvalue}{the global maximum value, i.e. the maximum of the Gaussian component with the largest value. Default is 1.}

\item{ratio}{maximum ratio of the local maxima, local optima are randomly generated within \code{[0,globalvalue*ratio]}. Has to be larger than 0 and smaller than 1. Defaults to 0.8.}

\item{seed}{seed for the random number generator used before creation of the landscape. Generator status will be saved and reset afterwards.}
}
\value{
returns a function. The function takes a point (vector) as input, with as many values as specified in \code{dimension}.
The function returns a vector value, representing the output from the two landscapes landscape.
}
\description{
This function is based on the Gaussian Landscape Generator by Bo Yuan and Marcus Gallagher.
The difference to \code{\link{spotGlgCreate}} is, that this function creates one landscape
and a second one is created by rotating the first. This can be used as a simple two-objective
test function.
}
\references{
B. Yuan and M. Gallagher (2003) "On Building a Principled Framework for Evaluating and Testing Evolutionary Algorithms: A Continuous Landscape Generator".
In Proceedings of the 2003 Congress on Evolutionary Computation, IEEE, pp. 451-458, Canberra, Australia.
}
\seealso{
\code{\link{spotGlgCreate}} \code{\link{spotGlgCreateN}} \code{\link{spotGlgCreateRotSearched}}
}

