% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess_missing_data_pca.R
\name{assess_missing_data_pca}
\alias{assess_missing_data_pca}
\title{Vizualise how missing data thresholds affect sample clustering}
\usage{
assess_missing_data_pca(
  vcfR,
  popmap = NULL,
  thresholds = NULL,
  clustering = TRUE
)
}
\arguments{
\item{vcfR}{a vcfR object}

\item{popmap}{set of population assignments that will be used to color code the plots}

\item{thresholds}{optionally specify a vector of missing data filtering thresholds to explore}

\item{clustering}{use partitioning around medoids (PAM) to do unsupervised
clustering on the output? (default = TRUE, max clusters = # of levels in popmap + 2)}
}
\value{
a series of plots showing the clustering of all samples in two-dimensional space
}
\description{
This function can be run in two ways: 1) Without 'thresholds' specified. This will run a PCA
for the input vcf without filtering, and visualize the clustering of samples in two-dimensional
space, coloring each sample according to a priori population assignment given in the popmap.
2) With 'thresholds' specified. This will filter your input vcf file to the specified
missing data thresholds, and run a PCA for each filtering iteration.
For each iteration, a 2D plot will be output showing clustering according to the
specified popmap. This option is ideal for assessing the effects of missing data
on clustering patterns.
}
\examples{
assess_missing_data_pca(vcfR = SNPfiltR::vcfR.example,
popmap = SNPfiltR::popmap,
thresholds = c(.6,.8))
}
