\name{paulsen}
\alias{paulsen}
\docType{data}
\title{Neurotransmission in Guinea Pig Brains}
\description{
    The 'paulsen' data frame has 346 rows and 1 columns.  

     Sections were prepared from the brain of adult guinea pigs.
     Spontaneous currents that flowed into individual brain cells were
     then recorded and the peak amplitude of each current measured. 
     The aim of the experiment  was to see if the current flow was
     quantal in nature (i.e. that it is not a single burst but instead
     is built up of many smaller bursts of current).  If the current
     was indeed quantal then it would be expected that the distribution
     of the current amplitude would be multimodal with modes at regular
     intervals.  The modes would be expected to decrease in magnitude
     for higher current amplitudes.
}
\usage{data(paulsen)}
\format{
  This data frame contains the following column:
  \describe{
    \item{y}{ The current flowing into individual brain cells. The currents
          are measured in pico-amperes.}
  }
}
\source{
    The data were kindly made available by Dr. O. Paulsen of the
     Department of Pharmacology, University of Oxford. 

     Paulsen, O. and Heggelund, P. (1994) The quantal size at
     retinogeniculate  synapses determined from spontaneous and evoked
     EPSCs in guinea-pig thalamic  slices. \emph{Journal of Physiology},
     \bold{480}, 505-511.
}
\examples{
data(paulsen)
hist(paulsen$y,prob=TRUE)
}
\keyword{datasets}
