% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.selection.R
\name{plot.selection}
\alias{plot.selection}
\title{Plots to visualize the selection}
\usage{
\method{plot}{selection}(x, ...)
}
\arguments{
\item{x}{Fitted \code{'selection'} object from \code{smle_select}.}

\item{...}{Additional arguments to the plot function.}
}
\value{
No return value, called for side effects.
}
\description{
This function constructs a sparsity vs. selection criterion curve for a selection object.
 When EBIC is used with voting, it also constructs a histogram showing the voting result.
}
\examples{
Data<-Gen_Data(correlation="MA",family = "gaussian")
fit<-SMLE(Data$Y,Data$X,k=20,family = "gaussian")
E<-smle_select(fit)
#Then E is a object of "selection"
plot(E)

}
