% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{runif_sm}
\alias{runif_sm}
\title{Sample from the uniform distribution on the Stiefel manifold.}
\usage{
runif_sm(num, ip, ir)
}
\arguments{
\item{num}{number of observations or sample size.}

\item{ip}{the first dimension \eqn{p} of the matrix.}

\item{ir}{the second dimension \eqn{r} of the matrix.}
}
\value{
an array with dimension \code{num}, \code{ip} and \code{ir} containing a sample of draws from the uniform distribution on the Stiefel manifold.
}
\description{
This function draws a sample from the uniform distribution on the Stiefel manifold.
}
\details{
The Stiefel manifold with dimension \eqn{p} and \eqn{r} (\eqn{p \geq r}) is a space whose points are \eqn{r}-frames in \eqn{R^p}.
A set of \eqn{r} orthonormal vectors in \eqn{R^p} is called an \eqn{r}-frame in \eqn{R^p}.
The Stiefel manifold is a collection of \eqn{p \times r} full rank matrices \eqn{X} such that \eqn{X'X = I_r}.
}
\examples{

runif_sm(10,4,2)

}
\author{
Yukai Yang, \email{yukai.yang@statistik.uu.se}
}
\keyword{utils}
