% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparseSIR.R
\name{sparseSIR}
\alias{sparseSIR}
\title{sparse SIR}
\usage{
sparseSIR(
  object,
  inter_len,
  adaptive = FALSE,
  sel_prop = 0.05,
  parallel = FALSE,
  ncores = NULL
)
}
\arguments{
\item{object}{an object of class \code{ridgeRes} as obtained from the 
function \code{\link{ridgeSIR}}}

\item{inter_len}{(numeric) vector with interval lengths}

\item{adaptive}{should the function returns the list of strong zeros and non
strong zeros (logical). Default to FALSE}

\item{sel_prop}{used only when \code{adaptive = TRUE}. Fraction of the 
coefficients that will be considered as strong zeros and strong non zeros.
Default to 0.05}

\item{parallel}{whether the computation should be performed in parallel or
not. Logical. Default is FALSE}

\item{ncores}{number of cores to use if \code{parallel = TRUE}. If left to 
NULL, all available cores minus one are used}
}
\value{
S3 object of class \code{sparseRes}: a list consisting of
\itemize{
   \item{\code{sEDR}}{ the estimated EDR space (a p x d matrix)}
   \item{\code{alpha}}{ the estimated shrinkage coefficients (a vector having
   a length similar to \code{inter_len})}
   \item{\code{quality}}{ a vector with various qualities for the model (see
   Details)}
   \item{\code{adapt_res}}{ if \code{adaptive = TRUE}, a list of two vectors: 
   \itemize{
     \item{\code{nonzeros}}{ indexes of variables that are strong non zeros}
     \item{\code{zeros}}{ indexes of variables that are strong zeros}
   }}
   \item{\code{parameters}}{ a list of hyper-parameters for the method: 
   \itemize{
     \item{\code{inter_len}}{ lengths of intervals}
     \item{\code{sel_prop}}{ if \code{adaptive = TRUE}, fraction of the 
     coefficients which are considered as strong zeros or strong non zeros}
   }}
   \item{\code{rSIR}}{ same as the input \code{object}}
   \item{\code{fit}}{ a list for LASSO fit with:
   \itemize{
     \item{\code{glmnet}} result of the \code{\link[glmnet]{glmnet}} function
     \item{\code{lambda}} value of the best Lasso parameter by CV
     \item{\code{x}} exploratory variable values as passed to fit the model
   }}
 }
 
 @details Different quality criteria used to select the best models among a
 list of models with different interval definitions. Quality criteria are:
 log-likelihood (\code{loglik}), cross-validation error as provided by the
 function \code{\link[glmnet]{glmnet}}, two versions of the AIC (\code{AIC} 
 and \code{AIC2}) and of the BIC (\code{BIC} and \code{BIC2}) in which the 
 number of parameters is either the number of non null intervals or the 
 number of non null parameters with respect to the original variables.
}
\description{
\code{sparseSIR} performs the second step of the method (shrinkage of ridge
SIR results
}
\examples{
set.seed(1140)
tsteps <- seq(0, 1, length = 200)
nsim <- 100
simulate_bm <- function() return(c(0, cumsum(rnorm(length(tsteps)-1, sd=1))))
x <- t(replicate(nsim, simulate_bm()))
beta <- cbind(sin(tsteps*3*pi/2), sin(tsteps*5*pi/2))
beta[((tsteps < 0.2) | (tsteps > 0.5)), 1] <- 0
beta[((tsteps < 0.6) | (tsteps > 0.75)), 2] <- 0
y <- log(abs(x \%*\% beta[ ,1]) + 1) + sqrt(abs(x \%*\% beta[ ,2]))
y <- y + rnorm(nsim, sd = 0.1)
res_ridge <- ridgeSIR(x, y, H = 10, d = 2, mu2 = 10^8)
res_sparse <- sparseSIR(res_ridge, rep(10, 20))

}
\references{
{Picheny, V., Servien, R., and Villa-Vialaneix, N. (2019) 
Interpretable sparse SIR for digitized functional data. 
\emph{Statistics and Computing}, \strong{29}(2), 255--267.}
}
\seealso{
\code{\link{ridgeSIR}}, \code{\link{project.sparseRes}}, 
\code{\link{SISIR}}
}
\author{
{Victor Picheny, \email{victor.picheny@inrae.fr}\cr
Remi Servien, \email{remi.servien@inrae.fr}\cr
Nathalie Vialaneix, \email{nathalie.vialaneix@inrae.fr}}
}
