% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SIRItoILTM.R
\name{SIRItoILTM}
\alias{SIRItoILTM}
\title{Projects a SIRI data frame to a spatial points object with Israel's TM grid}
\usage{
SIRItoILTM(SIRIdf, epsg = NULL)
}
\arguments{
\item{SIRIdf}{A SIRI df after organizeSIRIdf (SIRIdf3)}

\item{epsg}{a coordinate system code ( can be extracted using "make_EPSG" and searching the table ),
default is NULL with Israel's TM Grid (epsg 2039)}
}
\value{
A \code{\link[sp]{SpatialPointsDataFrame}} with SIRI's real-time data
}
\description{
Projects a subset of the SIRI data frame to a \code{\link[sp]{SpatialPointsDataFrame}} With Israel's TM projection (epsg 2039).
Requires the product of \code{\link{organizeSIRIdf}}
}
\details{
Requires the product of \code{\link{organizeSIRIdf}},
is interchangeable with \link[SIRItoGTFS]{SIRItoSP}.
the function is a part of STG and should not be used on it's own.
}
\section{Warning}{

Do Not use this function on it's own, it is meant to be used only as part of the STG process
}

\references{
Bogin, D., Levy, N. and Ben-Elia E. (2018) \emph{Estimation of public transport service reliability using Big Data and open source tools}
}
\seealso{
\code{\link{STG}}, \code{\link{SIRItoSP}}, \code{\link{organizeSIRIdf}}
}
\keyword{internal}
\keyword{misc}
\keyword{spatial}
