% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-SimParamBee.R
\name{downsizePUnif}
\alias{downsizePUnif}
\title{Sample the downsize proportion - proportion of removed workers in
  downsizing}
\usage{
downsizePUnif(colony, n = 1, min = 0.8, max = 0.9)
}
\arguments{
\item{colony}{\code{\link{Colony-class}}}

\item{n}{integer, number of samples}

\item{min}{numeric, lower limit for \code{downsizePUnif}}

\item{max}{numeric, upper limit for \code{downsizePUnif}}
}
\value{
numeric, downsize proportion
}
\description{
Sample the downsize proportion - proportion of removed workers
  in downsizing - used when \code{p = NULL} (see
  \code{\link{SimParamBee}$downsizeP}).

  This is just an example. You can provide your own functions that satisfy
  your needs!
}
\examples{
downsizePUnif()
downsizePUnif()
p <- downsizePUnif(n = 1000)
hist(p, breaks = seq(from = 0, to = 1, by = 0.01), xlim = c(0, 1))
}
\seealso{
\code{\link{SimParamBee}} field \code{downsizeP}
}
