% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elicitConcProb.R
\name{elicitConcProb}
\alias{elicitConcProb}
\title{Elicit a concordance probability for two uncertain quantities, and plot a joint sample}
\usage{
elicitConcProb(fit1, fit2, m1, m2, d = c("best", "best"), n = 10000)
}
\arguments{
\item{fit1}{An elicitation fit produced from the \code{fitdist}
command for the first uncertain quantity X_1.}

\item{fit2}{An elicitation fit produced from the \code{fitdist}
command for the second uncertain quantity X_2.}

\item{m1}{The elicited (or fitted) median of X_1.}

\item{m2}{The elicited (or fitted) median of X_2.}

\item{d}{A vector of distributions to be used for each elicited quantity: a string with elements chosen from
\code{"Normal", "Student-t", "Gamma", "Log normal" "Log Student-t", "Beta"}. The default is to use 
the best fitting distribution in each case.}

\item{n}{The number of sampled (X_1, X_2) pairs to be plotted.}
}
\value{
A matrix of sampled values, one row per sample.
}
\description{
Given two elicited marginal distributions, open a browser in which one specifies a quadrant
probability P(X_1 > m_1, X_2 > m_2), where m_1 and m_2 are the elicited medians of X_1 and X_2.
A joint sample from the distribution of X_1 and X_2 is generated, using the two elicited marginal
distributions and a bivariate normal copula.
}
\examples{
\dontrun{
p1 <- c(0.25, 0.5, 0.75)
v1 <- c(0.5, 0.55, 0.6)
v2 <- c(0.22, 0.3, 0.35)
myfit1 <- fitdist(v1, p1, 0, 1)
myfit2 <- fitdist(v2, p1, 0, 1)
elicitConcProb(myfit1, myfit2, 0.55, 0.3, d=c("Beta", "Beta"))
}
}
\author{
Jeremy Oakley <j.oakley@sheffield.ac.uk>
}

