% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worms_api_functions.R
\name{add_worms_taxonomy}
\alias{add_worms_taxonomy}
\title{Add WoRMS taxonomy hierarchy to AphiaIDs or scientific names}
\usage{
add_worms_taxonomy(
  aphia_ids,
  scientific_names = NULL,
  add_rank_to_hierarchy = FALSE,
  verbose = TRUE,
  aphia_id = deprecated(),
  scientific_name = deprecated()
)
}
\arguments{
\item{aphia_ids}{Numeric vector of AphiaIDs.}

\item{scientific_names}{Optional character vector of scientific names (same length as \code{aphia_id}).}

\item{add_rank_to_hierarchy}{Logical (default FALSE). If TRUE, includes rank labels in
the concatenated hierarchy string.}

\item{verbose}{Logical (default TRUE). If TRUE, prints progress updates.}

\item{aphia_id}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
Use \code{aphia_ids} instead.}

\item{scientific_name}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
Use \code{scientific_names} instead.}
}
\value{
A \code{tibble} with taxonomy columns added, including:
\itemize{
\item \code{aphia_id}, \code{scientific_name}
\item \code{worms_kingdom}, \code{worms_phylum}, \code{worms_class}, \code{worms_order},
\code{worms_family}, \code{worms_genus}, \code{worms_species}
\item \code{worms_scientific_name}, \code{worms_hierarchy}
}
}
\description{
This function enhances a dataset of AphiaIDs (and optionally scientific names)
with their complete hierarchical taxonomy from the World Register of Marine Species (WoRMS).
Missing AphiaIDs can be resolved from scientific names automatically.
}
\examples{
\donttest{
# Using AphiaID only
add_worms_taxonomy(c(1080, 109604), verbose = FALSE)

# Using a combination of AphiaID and scientific name
add_worms_taxonomy(
  aphia_ids = c(NA, 109604),
  scientific_names = c("Calanus finmarchicus", "Oithona similis"),
  verbose = FALSE
)
}

}
