% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_plots.R
\name{scatter.plot.simple}
\alias{scatter.plot.simple}
\title{Simple scatter plot, adding marginal histogram by default.}
\usage{
scatter.plot.simple(
  data,
  x,
  y,
  size0 = 0.2,
  alpha0 = 0.3,
  dilute = FALSE,
  add_hist = TRUE,
  add_stat_cor = FALSE
)
}
\arguments{
\item{data}{dataset}

\item{x}{x}

\item{y}{y}

\item{size0}{point size, default to 1 of nobs<1000, 0.4 if nobs>1000}

\item{alpha0}{alpha of point}

\item{dilute}{a number or logical, dafault to TRUE, will plot
\code{nrow(data_long)/dilute} data. For example, if dilute = 5 will plot
1/5 of the data. if dilute = TRUE will plot half of the data.}

\item{add_hist}{optional to add marginal histogram using
\code{ggExtra::ggMarginal} but notice if add histogram, what is returned is no
longer a ggplot2 object}

\item{add_stat_cor}{add correlation and p-value from \code{ggpubr::stat_cor}}
}
\value{
ggplot2 object if \code{add_hist = FALSE}
}
\description{
Simple scatter plot, adding marginal histogram by default.
}
\examples{
scatter.plot.simple(data = iris, x = "Sepal.Length", y = "Petal.Length")

}
