% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SHAP_funcs.R
\name{shap.prep.interaction}
\alias{shap.prep.interaction}
\title{Prepare the interaction SHAP values from predict.xgb.Booster}
\usage{
shap.prep.interaction(xgb_model, X_train)
}
\arguments{
\item{xgb_model}{a xgboost model object}

\item{X_train}{the dataset of predictors used for the xgboost model}
}
\value{
a 3-dimention array: #obs x #features x #features
}
\description{
\code{shap.prep.interaction} just runs \code{shap_int <- predict(xgb_mod, (X_train), predinteraction = TRUE)}, thus it may not be necessary.
Read more about the xgboost predict function at \code{xgboost::predict.xgb.Booster}. Note that this functionality is unavailable for LightGBM models.
}
\examples{
# To get the interaction SHAP dataset for plotting:
# fit the xgboost model
mod1 = xgboost::xgboost(
  data = as.matrix(iris[,-5]), label = iris$Species,
  gamma = 0, eta = 1, lambda = 0,nrounds = 1, verbose = FALSE)
# Use either:
data_int <- shap.prep.interaction(xgb_mod = mod1,
                                  X_train = as.matrix(iris[,-5]))
# or:
shap_int <- predict(mod1, as.matrix(iris[,-5]),
                    predinteraction = TRUE)

# **SHAP interaction effect plot **
shap.plot.dependence(data_long = shap_long_iris,
                           data_int = shap_int_iris,
                           x="Petal.Length",
                           y = "Petal.Width",
                           color_feature = "Petal.Width")
}
