% Generated by roxygen2 (4.0.2): do not edit by hand
\name{confun}
\alias{confun}
\title{Connectivity function and cumulative connectivity function.}
\usage{
confun(x, r, R, h, adjust = 1, preGraph = NULL, ...)
}
\arguments{
\item{x}{Point pattern}

\item{r}{Vector of distances to estimate the function}

\item{R}{The radius for generating the network, as geometric graph.}

\item{h}{Smoothing parameter. h=0 and h>0 mean different things, see Details.}

\item{adjust}{Adjust h by this factor (default=1).}

\item{preGraph}{Precomputed network/graph, as a spatgraph-object. Alternative to R.}

\item{...}{ignored.}
}
\value{
fv-object, see \link{spatstat} for more. Theoretical values unknown.
}
\description{
Amount of network connected pairs as a function of distance.
}
\details{
If h=0 we compute the cumulative version of the connecitivity function,
corresponding to Ripley's K-function under the condition that the points
in each pair must belong to the same component in an underlying network.

The underlying network can be given, or it will be computed as a geometric graph with
parameter 'R'. If given as 'preGraph', it must be a \pkg{spatgraphs}-object, with same
dimensions as the point pattern.

If h>0: Compute the probability of a pair being in the same component given their distance is ~ r.
Uses kernel smoothing with bandwidth h.

Sensible defaults are computed for h and R if not given.

Border correction is done via translation correction. The bias is unknown as the network censoring
is quite complex.

Theoretical values are unknown due to the graph conditioning.
}
\examples{
\dontrun{
x <- rMatClust(10, 0.1, 10)
plot(Cx<-confun(x,h=0, R=0.1))

# fit wrong model
ftho <- thomas.estpcf(x)
yf <- function()rThomas(ftho$par[1], ftho$par[2], x$n/ftho$par[1])
CC <- envelope(x, fun=confun, h=0, sim=yf, R=0.1)
C <- envelope(x, fun=confun, sim=yf, R=0.1)

plot(CC)
plot(C)
}
}

