% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semCluster.R
\name{extractClusters}
\alias{extractClusters}
\title{Cluster extraction utility}
\usage{
extractClusters(
  graph,
  data,
  group = NULL,
  membership = NULL,
  map = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{graph}{Input network as an igraph object.}

\item{data}{A matrix or data.frame. Rows correspond to subjects, and
columns to graph nodes (variables).}

\item{group}{A binary vector. This vector must be as long as the
number of subjects. Each vector element must be 1 for cases and 0
for control subjects. Group specification enables node perturbation
testing. By default, \code{group = NULL}.}

\item{membership}{A vector of cluster membership IDs. If NULL, clusters
will be automatically generated with \code{\link[SEMgraph]{clusterGraph}}
using the edge betweenness clustering ("ebc") algorithm.}

\item{map}{Logical value. If TRUE, the plot of the input graph
(coloured by cluster membership) will be generated along with independent
module plots. If the input graph is very large, plotting could be
computationally intensive (by default, \code{map = FALSE}).}

\item{verbose}{Logical value. If TRUE, a plot will be showed for each
cluster.}

\item{...}{Currently ignored.}
}
\value{
A list of 3 objects:
\enumerate{
\item "clusters", list of clusters as igraph objects;
\item "fit", list of fitting results for each cluster as a lavaan object;
\item "dfc", data.frame of summary results.
}
}
\description{
Extract and fit clusters from an input graph.
}
\examples{

\donttest{
# Nonparanormal(npn) transformation
als.npn <- transformData(alsData$exprs)$data

adjdata <- SEMbap(alsData$graph, als.npn)$data

# Clusters creation
clusters <- extractClusters(alsData$graph, adjdata, alsData$group)
print(clusters$dfc)
head(parameterEstimates(clusters$fit$HM1))
head(parameterEstimates(clusters$fit$HM2))
head(parameterEstimates(clusters$fit$HM4))
gplot(clusters$clusters$HM2)

# Map cluster on the input graph
g <- alsData$graph
c <- clusters$clusters$HM2
V(g)$color <- ifelse(V(g)$name \%in\% V(c)$name, "gold", "white")
gplot(g)
}

}
\author{
Fernando Palluzzi \email{fernando.palluzzi@gmail.com}
}
