% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semPaths.R
\name{SEMdag}
\alias{SEMdag}
\title{Estimate the optimal DAG from an input graph}
\usage{
SEMdag(
  graph,
  data,
  gnet = NULL,
  d = 0,
  beta = 0,
  lambdas = NA,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{graph}{An igraph object.}

\item{data}{A matrix whith rows corresponding to subjects, and
columns to graph nodes (variables).}

\item{gnet}{Reference "global" network as an igraph object. If given,
new edges will be added to the final DAG only if present in the
reference network.}

\item{d}{An integer value indicating the maximum length of indirect
interactions between pairs of nodes. If \code{d = 1}, direct interactions
between nodes will be searched in the reference interactome (if given).
If \code{d > 1}, indirect interactions of length d or shorter (i.e.,
with at most \code{d - 1} connectors) between bow-free nodes will be
searched. Setting \code{d = 0}, is equivalent to \code{gnet = NULL}.}

\item{beta}{Numeric value. Minimum absolute LASSO beta coefficient for
a new interaction to be retained in the final model. By default,
\code{beta = 0}.}

\item{lambdas}{A vector of regularization LASSO lambda values.
Cross-validation (n > 100) or BIC-based (n <= 100) optimal lambdas
for each response variable will be selected. If lambdas is NULL, the
\code{\link[glmnet]{glmnet}} default is enabled. If lambdas is NA
(default), the tuning-free scheme is enabled by fixing
lambdas = sqrt(log(p)/n), as suggested by Janková and van de Geer (2015).
This will both reduce computational time and provide the same result
at each run.}

\item{verbose}{A logical value. If FALSE (default), the processed graphs
will not be plotted to screen.}

\item{...}{Currently ignored.}
}
\value{
A list of 3 igraph objects:
\enumerate{
\item "dag", the estimated DAG;
\item "dag.red", new estimated connections;
\item "dag.blue", connections preserved from the input graph.
}
}
\description{
Extract the optimal DAG from an input graph, using the
LASSO-based algorithm, implememted in \code{\link[glmnet]{glmnet}}.
}
\details{
The optimal DAG is estimated after node topological order,
using successive penalized (L1) regressions. If the input graph is not
acyclic, a warning message will be raised, and a cycle-breaking algorithm
will be applied (see \code{\link[SEMgraph]{graph2dag}} for details).
Output DAG edges will be colored in blue, if they were present in the
input graph, and in red, if they are new edges generated by LASSO
screening.
}
\examples{

# DAG estimation
G <- SEMdag(graph = sachs$graph, data = log(sachs$pkc), beta = 0.05)

# Model fitting
sem <- SEMrun(graph = G$dag, data = log(sachs$pkc), group = sachs$group)

# Graphs
old.par <- par(no.readonly = TRUE)
par(mfrow=c(2,2), mar=rep(1,4))
plot(sachs$graph, layout=layout.circle, main="input graph")
plot(G$dag, layout=layout.circle, main = "Output DAG")
plot(G$dag.blue, layout=layout.circle, main = "Inferred old edges")
plot(G$dag.red, layout=layout.circle, main = "Inferred new edges")
par(old.par)

}
\references{
Shojaie A, Michailidis G (2010). Penalized likelihood methods for
estimation of sparse high-dimensional directed acyclic graphs.
Biometrika, 97(3): 519-538. <https://doi.org/10.1093/biomet/asq038>

Tibshirani R, Bien J, Friedman J, Hastie T, Simon N, Taylor J,
Tibshirani RJ (2012). Strong rules for discarding predictors in
lasso type problems. Royal Statistical Society: Series B
(Statistical Methodology), 74(2): 245-266.
<https://doi.org/10.1111/j.1467-9868.2011.01004.x>

Jana Jankova and Sara van de Geer (2015). Confidence intervals for
high-dimensional inverse covariance estimation. Electronic Journal
of Statistics, 9(1): 1205-1229.
<https://doi.org/10.1214/15-EJS1031>
}
\seealso{
\code{\link[SEMgraph]{modelSearch}}
}
\author{
Mario Grassi \email{mario.grassi@unipv.it}
}
