% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srs.polygon.r
\name{srs.polygon}
\alias{srs.polygon}
\title{Draws a Simple Random Sample (SRS) from an area resource (polygons).}
\usage{
srs.polygon(x, n)
}
\arguments{
\item{x}{A \code{SpatialPolygons} or \code{SpatialPolygonsDataFrame} 
object. This object
must contain at least 1 polygon.  If it contains more than 1 polygon, the
SRS sample is drawn from the union of all polygons.  Holes are respected.}

\item{n}{Sample size.  Number of locations to draw from the union of all
polygons contained in \code{x}.}
}
\value{
A \code{SpatialPointsDataFrame} containing locations in the SRS sample, 
in arbitrary order.  Attributes of the sample points (in the 
embedded data frame) are 
as follows: 
\itemize{
  \item \code{sampleID}: A unique identifier for every sample point.   
  
  \item \code{geometryID}: The ID of the polygon in \code{x} which each 
  sample point falls.  The 
  ID of polygons in \code{x} are \code{row.names(geometry(x))}. 
  \item Any attributes of the original polygons (in \code{x}). 
}

Additional attributes of the output object, beyond those which 
make it a \code{SpatialPointsDataFrame}, are:
\itemize{
   \item \code{frame}: Name of the input sampling frame.
   \item \code{frame.type}: Type of resource in sampling frame. (i.e., "polygon").
   \item \code{sample.type}: Type of sample drawn. (i.e., "SRS").
}
}
\description{
Draws a simple random sample from a \code{SpatialPolygons} or 
\code{SpatialPolygonsDataFrame} object.
}
\details{
The SRS sample is drawn by generating uniform random deviates 
for coordinates in the bounding box surrounding polygons
(e.g., \code{c(xmin, ymin) + c(dx,dy)*runif(2)}), tossing 
locations outside polygons 
until the required number is achieved.
}
\examples{

# A square grid oriented east-west
WA.samp <- srs.polygon( WA, 100 )   
plot( WA )
points( WA.samp, pch=16 )


}
\author{
Trent McDonald
}
\seealso{
\code{\link{bas.polygon}}, \code{\link{sss.polygon}}, 
\code{\link{hal.polygon}}, \code{\link{sdraw}}
}
\keyword{design}
\keyword{survey}

