% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srs.line.r
\name{srs.line}
\alias{srs.line}
\title{Draw a Simple Random Sample (SRS) from a linear resource.}
\usage{
srs.line(x, n)
}
\arguments{
\item{x}{A \code{SpatialLines} or \code{SpatialLinesDataFrame} object. 
This object must contain at least 1 line.}

\item{n}{Sample size.  Number of points to draw from the set of all lines
contained in \code{x}.}
}
\value{
A \code{SpatialPointsDataFrame} containing locations in the SRS sample, in
order along the amalgamated line.  Those on line 1 appear first, those on line 2 
second, etc. Attributes of the sample points (in the 
embedded data frame) are 
as follows: 
\itemize{
  \item \code{sampleID}: A unique identifier for every sample point.  
  \code{sampleID} starts with 1 at the first point and 
  increments by one for each.  \code{sampleID} orders 
  sample points along the amalgamated line.
  \item \code{geometryID}: The ID of the lines object in \code{x} on which each 
  sample point falls.  The 
  ID of lines in \code{x} are \code{row.names(geometry(x))}. 
  \item Any attributes of the original lines (in \code{x}) on which each sample 
  point falls.
}


Additional attributes of the output object, beyond those which 
make it a \code{SpatialPointsDataFrame}, are:
\itemize{
   \item \code{frame}: Name of the input sampling frame.
   \item \code{frame.type}: Type of resource in sampling frame. (i.e., "line").
   \item \code{sample.type}: Type of sample drawn. (i.e., "SRS").
}
}
\description{
Draws a simple random sample from a \code{SpatialLines*} object.  The 
\code{SpatialLines*} object represents a 2-dimensional line resource, such as a
river, highway, or coastline.
}
\details{
If \code{x} contains multiple lines, the lines are amalgamated before
sampling.   Conceptually, under amalgamation the lines in \code{x} are 
"stretched" straight and laid end-to-end in order of appearance in \code{x}.
The simple random sample is then drawn from the amalgamated line. 
Once drawn from the 1-D amalgamated line, sample points are mapped back 
to 2-dimensional space to fall on the lines in \code{x}. 

Note that the line is not discretized prior to sampling.  The sample points 
are selected from the set of continuous lines that contain 
an infinite number of points (up to machine precision anyway).
}
\examples{

# Draw fixed number of equi-distant points
HI.samp <- srs.line( HI.coast, 100 )   
plot( HI.coast, col=rainbow(length(HI.coast)) )
points( HI.samp, col="red", pch=16 )

# Inspect attributes of points with HI.samp@data

}
\author{
Trent McDonald
}
\seealso{
\code{\link{srs.polygon}}, \code{\link{srs.point}}, \code{\link{sdraw}}
}
\keyword{design}
\keyword{survey}

