% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTunableArgs.R
\name{getTunableArgs}
\alias{getTunableArgs}
\title{Get Tunable Arguments}
\usage{
getTunableArgs(model)
}
\arguments{
\item{model}{\linkS4class{SDMmodel} or \linkS4class{SDMmodelCV} object.}
}
\value{
character vector.
}
\description{
Returns the name of all function arguments that can be tuned for a given
model.
}
\examples{
# Acquire environmental variables
files <- list.files(path = file.path(system.file(package = "dismo"), "ex"),
                    pattern = "grd", full.names = TRUE)
predictors <- raster::stack(files)

# Prepare presence and background locations
p_coords <- virtualSp$presence
bg_coords <- virtualSp$background

# Create SWD object
data <- prepareSWD(species = "Virtual species", p = p_coords, a = bg_coords,
                   env = predictors, categorical = "biome")

# Train a Maxnet model and get tunable hyperparameters
model <- train(method = "Maxnet", data = data, fc = "l")
getTunableArgs(model)
}
\author{
Sergio Vignali
}
