% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict-Maxent.R
\docType{methods}
\name{predict,Maxent-method}
\alias{predict,Maxent-method}
\title{Predict Maxent}
\usage{
\S4method{predict}{Maxent}(object, data, type = c("cloglog", "logistic",
  "raw"), clamp = TRUE)
}
\arguments{
\item{object}{\linkS4class{Maxent} object.}

\item{data}{data.frame with the data for the prediction.}

\item{type}{character MaxEnt output type, possible values are "cloglog",
"logistic" and "raw", default is "cloglog".}

\item{clamp}{logical for clumping during prediction, default is \code{TRUE}.}
}
\value{
A vector with the prediction
}
\description{
Predict the output for a new dataset from a trained \linkS4class{Maxent}
model.
}
\details{
Used by the \code{\link{predict,SDMmodel-method}}, not exported.

The function performs the prediction in \strong{R} without calling the
\strong{MaxEnt} Java software. This results in a faster computation for large
datasets. The results might differ slightly from the Java software output.
}
\references{
Wilson P.D., (2009). Guidelines for computing MaxEnt model output
values from a lambdas file.
}
\author{
Sergio Vignali
}
