% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduceVar.R
\name{reduceVar}
\alias{reduceVar}
\title{Reduce Variables}
\usage{
reduceVar(model, th, metric, test = NULL, env = NULL,
  parallel = FALSE, use_jk = FALSE, permut = 10, use_pc = FALSE)
}
\arguments{
\item{model}{\code{\linkS4class{SDMmodel}} or \code{\linkS4class{SDMmodelCV}}
object.}

\item{th}{numeric. The contribution threshold used to remove variables.}

\item{metric}{character. The metric used to evaluate the models, possible
values are: "auc", "tss" and "aicc", used only if use_jk is \code{TRUE}.}

\item{test}{\code{\linkS4class{SWD}} object containing the test dataset used
to evaluate the model, not used with aicc, and if \code{use_jk = FALSE},
default is \code{NULL}.}

\item{env}{\code{\link[raster]{stack}} containing the environmental
variables, used only with "aicc", default is \code{NULL}.}

\item{parallel}{logical, if \code{TRUE} it uses parallel computation, default
is \code{FALSE}. Used only with \code{metric = "aicc"}, see details.}

\item{use_jk}{Flag to use the Jackknife AUC test during the variable
selection, if \code{FALSE} the function uses the percent variable
contribution, default is \code{FALSE}.}

\item{permut}{integer. Number of permutations, used if use_pc is
\code{FALSE}, default is 10.}

\item{use_pc}{logical, use percent contribution. If \code{TRUE} and the model
is trained using the \code{\linkS4class{Maxent}} method, the algorithm uses
the percent contribution computed by Maxent software to score the variable
importance, default is \code{FALSE}.}
}
\value{
The model trained using the selected variables.
}
\description{
Remove variables whose importance is less than the given threshold. The
function removes one variable at time and after trains a new model to get the
new variable contribution rank. If use_jk is TRUE the function checks if
after removing the variable the model performance decreases (according to the
given metric and based on the starting model). In this case the function
stops removing the variable even if the contribution is lower than the given
threshold.
}
\details{
Parallel computation is used only during the execution of the
predict function, and increases the speed only for large datasets. For small
dataset it may result in a longer execution, due to the time necessary to
create the cluster.
}
\examples{
\donttest{
# Acquire environmental variables
files <- list.files(path = file.path(system.file(package = "dismo"), "ex"),
                    pattern = "grd", full.names = TRUE)
predictors <- raster::stack(files)

# Prepare presence and background locations
p_coords <- virtualSp$presence
bg_coords <- virtualSp$background

# Create SWD object
data <- prepareSWD(species = "Virtual species", p = p_coords, a = bg_coords,
                   env = predictors, categorical = "biome")

# Split presence locations in training (80\%) and testing (20\%) datasets
datasets <- trainValTest(data, test = 0.2, only_presence = TRUE)
train <- datasets[[1]]
test <- datasets[[2]]

# Train a Maxnet model
model <- train(method = "Maxnet", data = train, fc = "lq")

# Remove all variables with permuation importance lower than 2\%
output <- reduceVar(model, th = 2, metric = "auc", test = test, permut = 1)

# Remove variables with permuation importance lower than 2\% only if testing
# TSS doesn't decrease
output <- reduceVar(model, th = 2, metric = "tss", test = test, permut = 1,
                    use_jk = TRUE)

# Remove variables with permuation importance lower than 2\% only if AICc
# doesn't increase
output <- reduceVar(model, th = 2, metric = "aicc", permut = 1,
                    use_jk = TRUE, env = predictors)

# Train a Maxent model
model <- train(method = "Maxent", data = train, fc = "lq")

# Remove all variables with percent contribution lower than 2\%
output <- reduceVar(model, th = 2, metric = "auc", test = test,
                    use_pc = TRUE)
}
}
\author{
Sergio Vignali
}
