% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varImp.R
\name{varImp}
\alias{varImp}
\title{Variable Importance}
\usage{
varImp(model, permut = 10)
}
\arguments{
\item{model}{\linkS4class{SDMmodel} or \linkS4class{SDMmodelCV} object.}

\item{permut}{integer. Number of permutations, default is 10.}
}
\value{
data.frame with the ordered permutation importance.
}
\description{
The function randomly permutes one variable at time (using training and
absence/background datasets) and computes the decrease in training AUC. The
result is normalized to percentages. Same implementation of MaxEnt java
software but with the additional possibility of running several permutations
to obtain a better estimate of the permutation importance. In case of more
than one permutation (default is 10) the average of the decrease in training
AUC is computed.
}
\details{
Note that it could return values slightly different from MaxEnt Java
software due to a different random permutation.

For \code{\link{SDMmodelCV}} objects the function returns the average and the
standard deviation of the permutation importances of the single models.
}
\examples{
\donttest{
# Acquire environmental variables
files <- list.files(path = file.path(system.file(package = "dismo"), "ex"),
                    pattern = "grd", full.names = TRUE)
predictors <- raster::stack(files)

# Prepare presence locations
p_coords <- condor[, 1:2]

# Prepare background locations
bg_coords <- dismo::randomPoints(predictors, 5000)

# Create SWD object
presence <- prepareSWD(species = "Vultur gryphus", coords = p_coords,
                       env = predictors, categorical = "biome")
bg <- prepareSWD(species = "Vultur gryphus", coords = bg_coords,
                 env = predictors, categorical = "biome")

# Split presence locations in training (80\%) and testing (20\%) datasets
datasets <- trainValTest(presence, test = 0.2)
train <- datasets[[1]]
test <- datasets[[2]]

# Train a model
model <- train(method = "Maxnet", p = presence, a = bg, fc = "l")

# Compute variable importance
vi <- varImp(model, permut = 5)
vi
}
}
\author{
Sergio Vignali
}
