% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corVar.R
\name{corVar}
\alias{corVar}
\title{Print Correlated Variables}
\usage{
corVar(bg, method = "spearman", cor_th = NULL, order = TRUE,
  remove_diagonal = TRUE)
}
\arguments{
\item{bg}{\linkS4class{SWD}. Locations used to test the correlation between
environmental variables.}

\item{method}{character. The method used to compute the correlation matrix,
default is "spearman".}

\item{cor_th}{numeric. If provided it prints only the variables whose
correlation coefficient is higher or lower than the given threshold, default
is \code{NULL}.}

\item{order}{logical, if \code{TRUE} the variable are ordered from the most
to the less highly correlated, default is \code{TRUE}.}

\item{remove_diagonal}{logical, if \code{TRUE} the values in the diagonal
are, removed, default is \code{TRUE}.}
}
\value{
The name of the correlated variables.
}
\description{
Utility that prints the name of correlated variables and the relative
correlation coefficient value.
}
\examples{
# Acquire environmental variables
files <- list.files(path = file.path(system.file(package = "dismo"), "ex"),
                    pattern = "grd", full.names = TRUE)
predictors <- raster::stack(files)

# Prepare background locations
bg_coords <- dismo::randomPoints(predictors, 10000)

# Create SWD object
bg <- prepareSWD(species = "Vultur gryphus", coords = bg_coords,
                 env = predictors, categorical = "biome")

# Get the correlation among all the environmental variables
corVar(bg, method = "spearman")

# Get the environmental variables that have a correlation greater or equal to
# the given threshold
corVar(bg, method = "pearson", cor_th = 0.8)
}
\author{
Sergio Vignali
}
