% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_GroupedGOTermPlot.R
\name{do_GroupedGOTermPlot}
\alias{do_GroupedGOTermPlot}
\title{Compute an overview of the GO terms associated with the input list of genes.}
\usage{
do_GroupedGOTermPlot(
  genes,
  org.db,
  levels.use = NULL,
  GO_ontology = "BP",
  min.overlap = 3,
  flip = TRUE,
  colors.use = c(Present = "#1e3d59", Absent = "#bccbcd"),
  legend.position = "bottom",
  reverse.levels = TRUE,
  axis.text.x.angle = 45,
  font.size = 10,
  font.type = "sans",
  plot.title = paste0("GO | ", GO_ontology),
  plot.subtitle = NULL,
  plot.caption = NULL,
  verbose = FALSE,
  return_matrices = FALSE,
  grid.color = "white",
  border.color = "black",
  plot.title.face = "bold",
  plot.subtitle.face = "plain",
  plot.caption.face = "italic",
  axis.title.face = "bold",
  axis.text.face = "plain",
  legend.title.face = "bold",
  legend.text.face = "plain"
)
}
\arguments{
\item{genes}{\strong{\code{\link[base]{character}}} | Vector of gene symbols to query for functional annotation.}

\item{org.db}{\strong{\code{OrgDB}} | Database object to use for the query.}

\item{levels.use}{\strong{\code{\link[base]{numeric}}} | Vector of numerics corresponding to the GO ontology levels to plot. If NULL will compute all recursively until there are no results.}

\item{GO_ontology}{\strong{\code{\link[base]{character}}} | GO ontology to use. One of:
\itemize{
\item \emph{\code{BP}}: For \strong{B}iological \strong{P}rocess.
\item \emph{\code{MF}}: For \strong{M}olecular \strong{F}unction.
\item \emph{\code{CC}}: For \strong{C}ellular \strong{C}omponent.
}}

\item{min.overlap}{\strong{\code{\link[base]{numeric}}} | Filter the output result to the terms which are supported by this many genes.}

\item{flip}{\strong{\code{\link[base]{logical}}} | Whether to invert the axis of the displayed plot.}

\item{colors.use}{\strong{\code{\link[base]{character}}} | Named vector with two colors assigned to the names \strong{\code{Present}} and \strong{\code{Absent}}.}

\item{legend.position}{\strong{\code{\link[base]{character}}} | Position of the legend in the plot. One of:
\itemize{
\item \emph{\code{top}}: Top of the figure.
\item \emph{\code{bottom}}: Bottom of the figure.
\item \emph{\code{left}}: Left of the figure.
\item \emph{\code{right}}: Right of the figure.
\item \emph{\code{none}}: No legend is displayed.
}}

\item{reverse.levels}{\strong{\code{\link[base]{logical}}} | Whether to place the higher levels first when computing the joint heatmap.}

\item{axis.text.x.angle}{\strong{\code{\link[base]{numeric}}} | Degree to rotate the X labels. One of: 0, 45, 90.}

\item{font.size}{\strong{\code{\link[base]{numeric}}} | Overall font size of the plot. All plot elements will have a size relationship with this font size.}

\item{font.type}{\strong{\code{\link[base]{character}}} | Base font family for the plot. One of:
\itemize{
\item \emph{\code{mono}}: Mono spaced font.
\item \emph{\code{serif}}: Serif font family.
\item \emph{\code{sans}}: Default font family.
}}

\item{plot.title, plot.subtitle, plot.caption}{\strong{\code{\link[base]{character}}} | Title, subtitle or caption to use in the plot.}

\item{verbose}{\strong{\code{\link[base]{logical}}} | Whether to show extra comments, warnings,etc.}

\item{return_matrices}{\strong{\code{\link[base]{logical}}} | Returns the matrices of grouped GO terms.}

\item{grid.color}{\strong{\code{\link[base]{character}}} | Color of the grid in the plot. In heatmaps, color of the border of the cells.}

\item{border.color}{\strong{\code{\link[base]{character}}} | Color for the border of the heatmap body.}

\item{plot.title.face, plot.subtitle.face, plot.caption.face, axis.title.face, axis.text.face, legend.title.face, legend.text.face}{\strong{\code{\link[base]{character}}} | Controls the style of the font for the corresponding theme element.  One of:
\itemize{
\item \emph{\code{plain}}: For normal text.
\item \emph{\code{italic}}: For text in itallic.
\item \emph{\code{bold}}: For text in bold.
\item \emph{\code{bold.italic}}: For text both in itallic and bold.
}}
}
\value{
A list containing all the matrices for the respective GO levels and all the individual and combined heatmaps.
}
\description{
Compute an overview of the GO terms associated with the input list of genes.
}
\examples{
\donttest{
  # Check Suggests.
  value <- SCpubr:::check_suggests(function_name = "do_GroupedGOTermPlot", passive = TRUE)

  if (isTRUE(value)){
    # Consult the full documentation in https://enblacar.github.io/SCpubr-book/

    # Need to load this library or equivalent.
    suppressMessages(library("org.Hs.eg.db"))

    # Define list of genes to query.
    genes.use <- c("CCR7", "CD14", "LYZ",
                   "S100A4", "MS4A1",
                   "MS4A7", "GNLY", "NKG7", "FCER1A",
                   "CST3", "PPBP")

    # Compute the grouped GO terms.
    out <- SCpubr::do_GroupedGOTermPlot(genes = genes.use,
                                        org.db = org.Hs.eg.db)
  } else if (base::isFALSE(value)){
    message("This function can not be used without its suggested packages.")
    message("Check out which ones are needed using `SCpubr::state_dependencies()`.")
  }
}
}
