# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Ridge-penalized precision matrix estimation (c++)
#' @description Ridge penalized matrix estimation via closed-form solution. Augmented from Adam Rothman's STAT 8931 code.
#'
#' @param S sample covariance matrix (denominator n).
#' @param lam tuning parameter for ridge penalty.
#' 
#' @return estimated Omega
#' 
#' @export
#' 
#' @keywords internal
#'
RIDGEc <- function(S, lam) {
    .Call('_SCPME_RIDGEc', PACKAGE = 'SCPME', S, lam)
}

#' @title Penalized precision matrix estimation via ADMM (c++)
#' 
#' @description Penalized precision matrix estimation using the ADMM algorithm
#' 
#' @details For details on the implementation of 'ADMMsigma', see the vignette
#' \url{https://mgallow.github.io/SCPME/}.
#'
#' @param S pxp sample covariance matrix (denominator n).
#' @param A option to provide user-specified matrix for penalty term. This matrix must have p columns. Defaults to identity matrix.
#' @param B option to provide user-specified matrix for penalty term. This matrix must have p rows. Defaults to identity matrix.
#' @param C option to provide user-specified matrix for penalty term. This matrix must have nrow(A) rows and ncol(B) columns. Defaults to identity matrix.
#' @param initOmega initialization matrix for Omega
#' @param initZ initialization matrix for Z2
#' @param initY initialization matrix for Y
#' @param lam postive tuning parameter for elastic net penalty.
#' @param alpha elastic net mixing parameter contained in [0, 1]. \code{0 = ridge, 1 = lasso}. Alpha must be a single value (cross validation across alpha not supported).
#' @param rho initial step size for ADMM algorithm.
#' @param tau optional constant used to ensure positive definiteness in Q matrix in algorithm
#' @param mu factor for primal and residual norms in the ADMM algorithm. This will be used to adjust the step size \code{rho} after each iteration.
#' @param tau_rho factor in which to increase step size \code{rho}.
#' @param iter_rho step size \code{rho} will be updated every \code{iter.rho} steps
#' @param crit criterion for convergence (\code{ADMM} or \code{loglik}). If \code{crit = loglik} then iterations will stop when the relative change in log-likelihood is less than \code{tol.abs}. Default is \code{ADMM} and follows the procedure outlined in Boyd, et al.
#' @param tol_abs absolute convergence tolerance. Defaults to 1e-4.
#' @param tol_rel relative convergence tolerance. Defaults to 1e-4.
#' @param maxit maximum number of iterations. Defaults to 1e4.
#' 
#' @return returns list of returns which includes:
#' \item{Iterations}{number of iterations.}
#' \item{lam}{optimal tuning parameter.}
#' \item{Omega}{estimated penalized precision matrix.}
#' \item{Z2}{estimated Z matrix.}
#' \item{Y}{estimated Y matrix.}
#' \item{rho}{estimated rho.}
#' 
#' @references
#' \itemize{
#' \item Boyd, Stephen, Neal Parikh, Eric Chu, Borja Peleato, Jonathan Eckstein, and others. 2011. 'Distributed Optimization and Statistical Learning via the Alternating Direction Method of Multipliers.' \emph{Foundations and Trends in Machine Learning} 3 (1). Now Publishers, Inc.: 1-122. \url{https://web.stanford.edu/~boyd/papers/pdf/admm_distr_stats.pdf}
#' \item Hu, Yue, Chi, Eric C, amd Allen, Genevera I. 2016. 'ADMM Algorithmic Regularization Paths for Sparse Statistical Machine Learning.' \emph{Splitting Methods in Communication, Imaging, Science, and Engineering}. Springer: 433-459.
#' \item Molstad, Aaron J., and Adam J. Rothman. (2017). 'Shrinking Characteristics of Precision Matrix Estimators. \emph{Biometrika.}. \url{https://doi.org/10.1093/biomet/asy023}
#' \item Rothman, Adam. 2017. 'STAT 8931 notes on an algorithm to compute the Lasso-penalized Gaussian likelihood precision matrix estimator.'
#' }
#' 
#' @author Matt Galloway \email{gall0441@@umn.edu}
#' 
#' @export
#' 
#' @keywords internal
#'
ADMMc <- function(S, A, B, C, initOmega, initZ, initY, lam, alpha = 1, tau = 10, rho = 2, mu = 10, tau_rho = 2, iter_rho = 10L, crit = "ADMM", tol_abs = 1e-4, tol_rel = 1e-4, maxit = 1e4L) {
    .Call('_SCPME_ADMMc', PACKAGE = 'SCPME', S, A, B, C, initOmega, initZ, initY, lam, alpha, tau, rho, mu, tau_rho, iter_rho, crit, tol_abs, tol_rel, maxit)
}

#' @title K fold (c++)
#' @description creates vector of shuffled indices.
#' @param n number of elements.
#' @param K number of folds.
#' @keywords internal
#'
NULL

#' @title CV ADMM penalized precision matrix estimation (c++)
#' @description Cross validation function for ADMMsigma.
#'
#' @param X option to provide a nxp matrix. Each row corresponds to a single observation and each column contains n observations of a single feature/variable.
#' @param S option to provide a pxp sample covariance matrix (denominator n). If argument is \code{NULL} and \code{X} is provided instead then \code{S} will be computed automatically.
#' @param Y option to provide nxr response matrix. Each row corresponds to a single response and each column contains n response of a single feature/response.
#' @param lam positive tuning parameters for elastic net penalty. If a vector of parameters is provided, they should be in increasing order.
#' @param alpha elastic net mixing parameter contained in [0, 1]. \code{0 = ridge, 1 = lasso}. Alpha must be a single value (cross validation across alpha not supported).
#' @param A option to provide user-specified matrix for penalty term. This matrix must have p columns. Defaults to identity matrix.
#' @param B option to provide user-specified matrix for penalty term. This matrix must have p rows. Defaults to identity matrix.
#' @param C option to provide user-specified matrix for penalty term. This matrix must have nrow(A) rows and ncol(B) columns. Defaults to identity matrix.
#' @param path option to return the regularization path. This option should be used with extreme care if the dimension is large. If set to TRUE, cores will be set to 1 and errors and optimal tuning parameters will based on the full sample. Defaults to FALSE.
#' @param tau optional constant used to ensure positive definiteness in Q matrix in algorithm
#' @param rho initial step size for ADMM algorithm.
#' @param mu factor for primal and residual norms in the ADMM algorithm. This will be used to adjust the step size \code{rho} after each iteration.
#' @param tau_rho factor in which to increase/decrease step size \code{rho}
#' @param iter_rho step size \code{rho} will be updated every \code{iter.rho} steps
#' @param crit criterion for convergence (\code{ADMM} or \code{loglik}). If \code{crit = loglik} then iterations will stop when the relative change in log-likelihood is less than \code{tol.abs}. Default is \code{ADMM} and follows the procedure outlined in Boyd, et al.
#' @param tol_rel relative convergence tolerance. Defaults to 1e-4.
#' @param maxit maximum number of iterations. Defaults to 1e4.
#' @param adjmaxit adjusted maximum number of iterations. During cross validation this option allows the user to adjust the maximum number of iterations after the first \code{lam} tuning parameter has converged. This option is intended to be paired with \code{warm} starts and allows for "one-step" estimators. Defaults to 1e4.
#' @param K specify the number of folds for cross validation.
#' @param crit_cv cross validation criterion (\code{loglik}, \code{penloglik}, \code{AIC}, or \code{BIC}). Defaults to \code{loglik}.
#' @param start specify \code{warm} or \code{cold} start for cross validation. Default is \code{warm}.
#' @param trace option to display progress of CV. Choose one of \code{progress} to print a progress bar, \code{print} to print completed tuning parameters, or \code{none}.
#' 
#' @return list of returns includes:
#' \item{lam}{optimal tuning parameter.}
#' \item{path}{array containing the solution path. Solutions will be ordered in ascending lambda values.}
#' \item{min.error}{minimum average cross validation error (cv_crit) for optimal parameters.}
#' \item{avg.error}{average cross validation error (cv_crit) across all folds.}
#' \item{cv.error}{cross validation errors (cv_crit).}
#' 
#' @keywords internal
#'
CV_ADMMc <- function(X, S, Y, A, B, C, lam, alpha = 1, path = FALSE, tau = 10, rho = 2, mu = 10, tau_rho = 2, iter_rho = 10L, crit = "ADMM", tol_abs = 1e-4, tol_rel = 1e-4, maxit = 1e4L, adjmaxit = 1e4L, K = 5L, crit_cv = "MSE", start = "warm", trace = "progress") {
    .Call('_SCPME_CV_ADMMc', PACKAGE = 'SCPME', X, S, Y, A, B, C, lam, alpha, path, tau, rho, mu, tau_rho, iter_rho, crit, tol_abs, tol_rel, maxit, adjmaxit, K, crit_cv, start, trace)
}

#' @title CV (no folds) ADMM penalized precision matrix estimation (c++)
#' @description Cross validation (no folds) function for shrink. This function is to be used with CVP_ADMM.
#'
#' @param X_train nxp training data matrix.
#' @param X_valid (n - q)xp validation data matrix matrix.
#' @param Y_train nxr training response matrix.
#' @param Y_valid (n - q)xr validation response matrix.
#' @param A option to provide user-specified matrix for penalty term. This matrix must have p columns. Defaults to identity matrix.
#' @param B option to provide user-specified matrix for penalty term. This matrix must have p rows. Defaults to identity matrix.
#' @param C option to provide user-specified matrix for penalty term. This matrix must have nrow(A) rows and ncol(B) columns. Defaults to identity matrix.
#' @param lam positive tuning parameters for elastic net penalty. If a vector of parameters is provided, they should be in increasing order.
#' @param alpha elastic net mixing parameter contained in [0, 1]. \code{0 = ridge, 1 = lasso}. Alpha must be a single value (cross validation across alpha not supported).
#' @param tau optional constant used to ensure positive definiteness in Q matrix in algorithm
#' @param rho initial step size for ADMM algorithm.
#' @param mu factor for primal and residual norms in the ADMM algorithm. This will be used to adjust the step size \code{rho} after each iteration.
#' @param tau_rho factor in which to increase/decrease step size \code{rho}
#' @param iter_rho step size \code{rho} will be updated every \code{iter.rho} steps
#' @param crit criterion for convergence (\code{ADMM} or \code{loglik}). If \code{crit = loglik} then iterations will stop when the relative change in log-likelihood is less than \code{tol.abs}. Default is \code{ADMM} and follows the procedure outlined in Boyd, et al.
#' @param tol_abs absolute convergence tolerance. Defaults to 1e-4.
#' @param tol_rel relative convergence tolerance. Defaults to 1e-4.
#' @param maxit maximum number of iterations. Defaults to 1e4.
#' @param adjmaxit adjusted maximum number of iterations. During cross validation this option allows the user to adjust the maximum number of iterations after the first \code{lam} tuning parameter has converged. This option is intended to be paired with \code{warm} starts and allows for "one-step" estimators. Defaults to 1e4.
#' @param crit_cv cross validation criterion (\code{MSE}, \code{loglik}, \code{penloglik} \code{AIC}, or \code{BIC}). Defaults to \code{MSE}.
#' @param start specify \code{warm} or \code{cold} start for cross validation. Default is \code{warm}.
#' @param trace option to display progress of CV. Choose one of \code{progress} to print a progress bar, \code{print} to print completed tuning parameters, or \code{none}.
#' 
#' @return cross validation errors (cv_crit)
#' 
#' @keywords internal
#'
CVP_ADMMc <- function(X_train, X_valid, Y_train, Y_valid, A, B, C, lam, alpha = 1, tau = 10, rho = 2, mu = 10, tau_rho = 2, iter_rho = 10L, crit = "ADMM", tol_abs = 1e-4, tol_rel = 1e-4, maxit = 1e4L, adjmaxit = 1e4L, crit_cv = "MSE", start = "warm", trace = "progress") {
    .Call('_SCPME_CVP_ADMMc', PACKAGE = 'SCPME', X_train, X_valid, Y_train, Y_valid, A, B, C, lam, alpha, tau, rho, mu, tau_rho, iter_rho, crit, tol_abs, tol_rel, maxit, adjmaxit, crit_cv, start, trace)
}

