% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppp.PPPFunctionLink.R
\name{PPPLogLinLink}
\alias{PPPLogLinLink}
\title{PPPLogLinLink}
\description{
Log linear link function. See also the PrePostProcessing documentation.
}
\details{
Log linear link function. The transform is log(x) if 0 < x < 1, else x -1,
and the inverse transform exp(x) if x < 0, else x + 1.
}
\examples{
## Start with data
XY = SBCK::dataset_like_tas_pr(2000)
X0 = XY$X0
X1 = XY$X1
Y0 = XY$Y0

## Define the PPP method
ppp = PPPLogLinLink$new( bc_method = CDFt , cols = 2 ,
                         pipe = list(PPPSSR),
                         pipe_kwargs = list(list(cols=2)) )

## And now the correction
## Bias correction
ppp$fit(Y0,X0,X1)
Z = ppp$predict(X1,X0)

}
\section{Super classes}{
\code{\link[SBCK:PrePostProcessing]{SBCK::PrePostProcessing}} -> \code{\link[SBCK:PPPFunctionLink]{SBCK::PPPFunctionLink}} -> \code{PPPLogLinLink}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PPPLogLinLink-new}{\code{PPPLogLinLink$new()}}
\item \href{#method-PPPLogLinLink-clone}{\code{PPPLogLinLink$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="SBCK" data-topic="PrePostProcessing" data-id="fit"><a href='../../SBCK/html/PrePostProcessing.html#method-PrePostProcessing-fit'><code>SBCK::PrePostProcessing$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="SBCK" data-topic="PrePostProcessing" data-id="predict"><a href='../../SBCK/html/PrePostProcessing.html#method-PrePostProcessing-predict'><code>SBCK::PrePostProcessing$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="SBCK" data-topic="PPPFunctionLink" data-id="itransform"><a href='../../SBCK/html/PPPFunctionLink.html#method-PPPFunctionLink-itransform'><code>SBCK::PPPFunctionLink$itransform()</code></a></span></li>
<li><span class="pkg-link" data-pkg="SBCK" data-topic="PPPFunctionLink" data-id="transform"><a href='../../SBCK/html/PPPFunctionLink.html#method-PPPFunctionLink-transform'><code>SBCK::PPPFunctionLink$transform()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PPPLogLinLink-new"></a>}}
\if{latex}{\out{\hypertarget{method-PPPLogLinLink-new}{}}}
\subsection{Method \code{new()}}{
Create a new PPPLogLinLink object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PPPLogLinLink$new(s = 1e-05, cols = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{s}}{The value where the function jump from exp to linear}

\item{\code{cols}}{Columns to apply the link function}

\item{\code{...}}{Others arguments are passed to PrePostProcessing}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `PPPLogLinLink` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PPPLogLinLink-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PPPLogLinLink-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PPPLogLinLink$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
