% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.shuffle.R
\name{SchaakeShuffle}
\alias{SchaakeShuffle}
\title{ShaakeShuffle class}
\description{
Perform the Schaake Shuffle
}
\details{
as fit/predict mode
}
\examples{
X0 = matrix( stats::runif(20) , ncol = 2 )
Y0 = matrix( stats::runif(20) , ncol = 2 )
ss = SchaakeShuffle$new()
ss$fit(Y0)
Z0 = ss$predict(X0)

}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{SchaakeShuffle$new()}}
\item \href{#method-fit}{\code{SchaakeShuffle$fit()}}
\item \href{#method-predict}{\code{SchaakeShuffle$predict()}}
\item \href{#method-clone}{\code{SchaakeShuffle$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new ShaakeShuffle object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SchaakeShuffle$new(Y0 = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Y0}}{[vector] The reference vector}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `ShaaleShuffle` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fit"></a>}}
\if{latex}{\out{\hypertarget{method-fit}{}}}
\subsection{Method \code{fit()}}{
Fit the model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SchaakeShuffle$fit(Y0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Y0}}{[vector] The reference vector}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-predict"></a>}}
\if{latex}{\out{\hypertarget{method-predict}{}}}
\subsection{Method \code{predict()}}{
Fit the model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SchaakeShuffle$predict(X0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X0}}{[vector] The vector to apply shuffle}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Z0 [vector] data shuffled
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SchaakeShuffle$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
