% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onload.R
\name{create_rec_service}
\alias{create_rec_service}
\title{Create Azure recommender service}
\description{
Method for the \link[AzureRMR:az_resource_group]{AzureRMR::az_resource_group} and \link[AzureRMR:az_subscription]{AzureRMR::az_subscription} classes.
}
\section{Usage}{
\preformatted{## R6 method for class 'az_subscription'
create_rec_service(name, location, hosting_plan, storage_type = c("Standard_LRS", "Standard_GRS"),
                   insights_location = c("East US", "North Europe", "West Europe", "South Central US"),
                   data_container = "inputdata", ..., wait = TRUE

## R6 method for class 'az_resource_group'
create_rec_service(name, hosting_plan, storage_type = c("Standard_LRS", "Standard_GRS"),
                   insights_location = c("East US", "North Europe", "West Europe", "South Central US"),
                   data_container = "inputdata", ..., wait = TRUE
}
}

\section{Arguments}{

\itemize{
\item \code{name}: The name of the recommender service.
\item \code{location}: For the subscription method, the location/region for the service. For the resource group method, this is taken from the location of the resource group.
\item \code{storage_type}: The replication strategy for the storage account for the service.
\item \code{insights_location}: Location for the application insights service giving you details on the webapp usage.
\item \code{data_container}: The name of the blob container within the storage account to use for storing datasets.
\item \code{wait}: Whether to wait until the service has finished provisioning.
\item \code{...} : Other named arguments to pass to the \link{az_template} initialization function.
}
}

\section{Details}{

This method deploys a new recommender service. The individual resources created are an Azure webapp, a storage account, and an application insights service for monitoring. Within the storage account, a blob container is created with name given by the \code{data_container} argument for storing input datasets.

For the az_subscription method, a resource group is also created to hold the resources. The name of the resource group will be the same as the name of the service.
}

\section{Value}{

An object of class \code{az_rec_service} representing the deployed recommender service.
}

\examples{
\dontrun{

rg <- AzureRMR::az_rm$
    new(tenant="myaadtenant.onmicrosoft.com", app="app_id", password="password")$
    get_subscription("subscription_id")$
    get_resource_group("rgname")

# create a new recommender service
rg$create_rec_service("myrec", hosting_plan="S2")

}
}
\seealso{
\link{get_rec_service}, \link{delete_rec_service}.

The architecture for the web service is documented \href{https://github.com/Microsoft/Product-Recommendations/blob/master/doc/architecture.md}{here}, and the specific template deployed by this method is \href{https://raw.githubusercontent.com/Microsoft/Product-Recommendations/master/saw/recommendationswebapp/core/arm/resources.json}{here}.
}
