checking2 <-
function(X,com=1){
 #X...2-dim data.frame with colums "x" and "alpha" containing the vertexes of the polygonial fuzzy number
 #function checks if X defines a polygonial fuzzy number (steps 1 to 5)
 #functions returns 0 in case of error, 1 otherwise
 #check1: if names are ok
 temp<-rep(1,5)
 if(names(X)[1]!=c("x")|names(X)[2]!=c("alpha")){
   temp[1]<-0
   print(paste("input has to be a data frame with column names x and alpha"))
   invisible(c(0))
 }
 #check2: if max and min are ok
 if(temp[1]==1){
  if(min(X$alpha)!=0 | max(X$alpha)!=1) {
  temp[2]<-0
  if(com==1){
   print(paste("input defines no polygonial fuzzy number - max alpha-value has to be 1, min 0"))
   }
   invisible(c(0))
  }
  }
 #check3: if x is increasing
 if(min(temp[1:2])==1){
  dat<-c(X$x[1],X$x)
  shifted<-c(X$x,X$x[nrow(X)])
  if(min(shifted-dat)<0) {
    temp[3]<-0
    if(com==1){
     print(paste("input defines no polygonial fuzzy number - x values must be non-decreasing",sep=""))
    }
    invisible(c(0))
   }
  }
 #check4: if alpha is increasing from 0 to 1
 if(min(temp[1:3])==1){
  A<-subset(X,X$alpha==1)
  cut1<-min(as.numeric(row.names(A)))
  cut2<-max(as.numeric(row.names(A)))
  fromto<-seq(cut1,cut2,by=1)
  difference<-setdiff(fromto,as.numeric(row.names(A)))
  Left<-X[1:cut1,]
  Right<-X[cut2:nrow(X),]
  dat<-c(Left$alpha[1],Left$alpha)
  shifted<-c(Left$alpha,Left$alpha[nrow(Left)])
  if(min(shifted-dat)<0|length(difference)>0) {
   temp[4]<-0
   if(com==1){
    print(paste("input defines no polygonial fuzzy number - alpha-levels must increase from 0 to 1 and decrease from 1 to 0"))
    }
    invisible(c(0))
   }
  } 
 #check 5: if alpha is decreasing from 1 to 0
 if(min(temp[1:4])==1){ 
  dat<-c(Right$alpha[1],Right$alpha)
  shifted<-c(Right$alpha,Right$alpha[nrow(Right)])
  if(min(dat-shifted)<0) {
   temp[5]<-0
   if(com==1){
   print(paste("input defines no polygonial fuzzy number - alpha-levels must increase from 0 to 1 and decrease from 1 to 0"))
   }
   invisible(c(0))
  }
 } 
 invisible(min(temp))
}

