% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune_parameters.R
\name{tune_parameters}
\alias{tune_parameters}
\title{Tuning and cross-validation of MERF parameters}
\usage{
tune_parameters(
  Y,
  X,
  data,
  dName,
  trControl,
  tuneGrid,
  seed = 11235,
  gg_theme = theme_minimal(),
  plot_res = TRUE,
  return_plot = FALSE,
  na.rm = TRUE,
  ...
)
}
\arguments{
\item{Y}{Continuous input value of target variable.}

\item{X}{Matrix or data.frame of predictive covariates.}

\item{data}{data.frame of survey sample data including the specified elements of \code{Y} and
\code{X}.}

\item{dName}{Character specifying the name of domain identifier, for which random intercepts
are modeled.}

\item{trControl}{Control parameters passed to \link[caret]{train}. Most important
parameters are \code{method} ("repeatedcv" for x-fold cross-validation), \code{number} (the number of folds)
and \code{repeats} (the number of repetitions). For further details see \link[caret]{trainControl}
and the example below.}

\item{tuneGrid}{A data.frame with possible tuning values. The columns must have the same names as the
tuning parameters. For this tuning function the grid must comprise entries for the following parameters:
\code{num.trees, mtry, min.node.size, splitrule}.}

\item{seed}{Enabling reproducibility of for cross-validation and tuning. Defaults to \code{11235}.}

\item{gg_theme}{Specify a predefined theme from \pkg{ggplot2}. Defaults to \code{theme_minimal}.}

\item{plot_res}{Optional logical. If \code{TRUE}, the plot with results of cross-validation and tuning
is shown. Defaults to \code{TRUE}.}

\item{return_plot}{If set to \code{TRUE}, a list of the comparative plot produced by \pkg{ggplot2}
is returned for further individual customization and processing.}

\item{na.rm}{Logical. Whether missing values should be removed. Defaults to \code{TRUE}.}

\item{...}{Additional parameters are directly passed to the random forest \link[ranger]{ranger} and/or
the training function \link[caret]{train}. For further details on possible parameters and examples
see \link[ranger]{ranger} or \link[caret]{train}.}
}
\value{
Prints requested optimal tuning parameters and (if requested) an additional
comparative plot produced by \pkg{ggplot2}.
}
\description{
Function \code{tune_parameters} allows to tune parameters for the implemented MERF method. Essentially,
this function can be understood as a modified wrapper for \link[caret]{train} from the package \pkg{caret},
treating MERFs as a custom method.
}
\details{
Tuning can be performed on the following four parameters: \code{num.trees} (the number of trees
for a forest), \code{mtry} (number of variables as split candidates at in each node), \code{min.node.size}
(minimal individual node size) and \code{splitrule} (general splitting rule). For details see
\link[ranger]{ranger}.
}
\examples{
\donttest{
# Loading data
data("eusilcA_pop")
data("eusilcA_smp")
library(caret)

income <- eusilcA_smp$eqIncome
X_covar <- eusilcA_smp[, -c(1, 16, 17, 18)]

# Specific characteristics of Cross-validation
fitControl <- trainControl(method = "repeatedcv", number = 5,
                           repeats = 1)

# Define a tuning-grid
merfGrid <- expand.grid(num.trees = 50, mtry = c(3, 7, 9),
                        min.node.size = 10, splitrule = "variance")

tune_parameters(Y = income, X = X_covar, data = eusilcA_smp,
                dName = "district", trControl = fitControl,
                tuneGrid = merfGrid)
}

}
\seealso{
\code{\link{SAEforest}}, \code{\link{MERFranger}}, \code{\link[caret]{train}},
\code{\link[ggplot2]{ggplot}}
}
