% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_SAEforest.R
\name{plot.SAEforest}
\alias{plot.SAEforest}
\title{Plot function for a 'SAEforest' object}
\usage{
\method{plot}{SAEforest}(
  x,
  num_features = 6,
  col = "darkgreen",
  fill = "darkgreen",
  alpha = 0.8,
  include_type = TRUE,
  horizontal = TRUE,
  gg_theme = theme_minimal(),
  lsize = 1.5,
  lty = "solid",
  grid_row = 2,
  out_list = FALSE,
  pdp_plot = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{SAEforest} including a random forest model of class \code{\link[ranger]{ranger}}.}

\item{num_features}{Number of features for which a partial dependence plot is required.}

\item{col}{Parameter specifying the color of selected plots. The argument must be specified
such that it can be processed by \code{\link[ggplot2]{aes}}. Defaults to a character name of the
color "darkgreen".}

\item{fill}{Parameter specifying the fill of selected plots. The argument must be specified
such that it can be processed by \code{\link[ggplot2]{aes}}. Defaults to a character name of the
color "darkgreen".}

\item{alpha}{Parameter specifying the transparency of \code{fill} for \code{\link[vip]{vip}} plots.
The argument must be a number in \code{[0,1]}.}

\item{include_type}{Logical. If set to \code{TRUE}, the type of importance specified in the fitting process
of the model is included in the \code{\link[vip]{vip}} plot. Defaults to \code{TRUE}.}

\item{horizontal}{Logical. If set to \code{TRUE}, the importance scores appear on the x-axis. If parameter is
set to \code{FALSE}, the importance scores are plot on the y-axis. Defaults to \code{TRUE}.}

\item{gg_theme}{Specify a predefined theme from \pkg{ggplot2}. Defaults to \code{theme_minimal}.}

\item{lsize}{Parameter specifying the line size of pdp plots. The argument must be specified
such that it can be processed by \code{\link[ggplot2]{aes}}. Defaults to 1.5.}

\item{lty}{Parameter specifying the line size of pdp plots. The argument must be specified
such that it can be processed by \code{\link[ggplot2]{aes}}. Defaults to "solid".}

\item{grid_row}{Parameter specifying the amount of rows for the joint pdp plot. Defaults to 2.}

\item{out_list}{Logical. If set to \code{TRUE}, a list of individual plots produced by \pkg{ggplot2}
is returned for further individual customization and processing. Defaults to \code{FALSE}.}

\item{pdp_plot}{Logical. If set to \code{TRUE}, partial dependence plots produced by \code{\link[pdp]{partial}}
from the package \pkg{pdp} are included. Defaults to \code{TRUE}.}

\item{...}{Optional additional inputs that are ignored for this method.}
}
\value{
Plots of variable importance and/or partial dependence of covariates ranked by corresponding
importance. Additionally, a list of individual plots can be returned facilitating individual
customization and exporting. See the following examples for details.
}
\description{
Plots model-specific characteristics of the fixed effects random forest component of
the MERF from a \code{\link{SAEforestObject}}. A variable importance plot is produced to visualize
the importance of individual covariates for the predictive performance of the model.
For the variable importance plot, arguments are passed internally to the function
\code{\link[vip]{vip}}. If requested, the plot function additionally provides a partial
dependence plot (pdp) to visualize the impact of a given number of influential covariates
on the target variable. The pdp plot is produced using \code{\link[pdp]{partial}} from
the package \pkg{pdp}. The plot-engine for both plots is \pkg{ggplot2}.
}
\details{
For the production of importance plots, be sure to specify the parameter of
\code{importance != 'none'} before producing estimates with function \code{\link{SAEforest_model}}.

For pdp plots, note that covariates of type factor or character cannot be used for partial dependence
plots. Dummy-variables can be used, however, their pdp plots are always lines connecting two effect
points for 0 and 1. Most informative pdp plots can be produced for continuous predictors.
}
\examples{
\donttest{
# Loading data
data("eusilcA_pop")
data("eusilcA_smp")

income <- eusilcA_smp$eqIncome
X_covar <- eusilcA_smp[, -c(1, 16, 17, 18)]

# Example 1:
# Calculating point estimates and discussing basic generic functions

model1 <- SAEforest_model(Y = income, X = X_covar, dName = "district",
                          smp_data = eusilcA_smp, pop_data = eusilcA_pop,
                          num.trees = 50)
plot(model1)
}

}
\seealso{
\code{\link{SAEforestObject}}
}
