% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_selection.R
\name{compute_p_si}
\alias{compute_p_si}
\title{Compute choice probabilities at posterior samples}
\usage{
compute_p_si(x, ncores = parallel::detectCores() - 1, recompute = FALSE)
}
\arguments{
\item{x}{An object of class \code{RprobitB_fit}.}

\item{ncores}{This function is parallelized, set the number of cores here.}

\item{recompute}{Set to \code{TRUE} to recompute the probabilities.}
}
\value{
The object \code{x}, including the object \code{p_si}, which is a matrix of
probabilities, observations in rows and posterior samples in columns.
}
\description{
This function computes the probability for each observed choice at the
(normalized, burned and thinned) samples from the posterior. These
probabilities are required to compute the \code{\link{WAIC}} and the
marginal model likelihood \code{\link{mml}}.
}
