% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare.R
\name{prepare}
\alias{prepare}
\title{Prepare empirical choice data.}
\usage{
prepare(
  form,
  choice_data,
  alternatives = NULL,
  re = NULL,
  id = "id",
  standardize = NULL,
  test_prop = NULL
)
}
\arguments{
\item{form}{A formula object that is used to specify the probit model.
The structure is \code{choice ~ A | B | C}, where
\itemize{
\item \code{A} are names of alternative and choice situation specific
covariates with a generic coefficient,
\item \code{B} are names of choice situation specific covariates with
alternative specific coefficients,
\item and \code{C} are names of alternative and choice situation specific
covariates with alternative specific coefficients.
}
Separate multiple covariates of one type by a \code{+} sign.
By default, alternative specific constants (ASCs) are added to the model
(for all except for the last alternative).
They can be removed by adding \code{+0} in the second spot.
See the vignette \code{vignette("data_management", package = "RprobitB")}
for more details.}

\item{choice_data}{A data frame of choice data in "wide" format (i.e. each row represents
one choice occasion) with the following requirements:
\itemize{
\item It must contain a column named \code{id} which contains unique
identifier for each decision maker.
\item It can contain a column named \code{choice} with the observed
choices, where \code{choice} must match the name of the dependent
variable in \code{form}.
Such a column is required for model fitting but not for prediction.
\item For each alternative specific covariate \emph{p} in \code{form} and each
choice alternative \emph{j} in \code{alternatives}, \code{choice_data}
must contain a column named \emph{p_j}.
\item For each covariate \emph{q} in \code{form} that is constant across
alternatives, \code{choice_data} must contain a column named \emph{q}.
}}

\item{alternatives}{A character vector with the names of the choice alternatives.
If not specified, the choice set is defined by the observed choices.}

\item{re}{A character (vector) of covariates of \code{form} with random effects.
If \code{re = NULL} (the default), there are no random effects.
To have random effects for the alternative specific constants, include
\code{"ASC"} in \code{re}.}

\item{id}{A character, the name of the column in \code{choice_data} that contains
unique identifier for each decision maker. The default is \code{"id"}.}

\item{standardize}{A character vector of names of covariates that get standardized.
Covariates of type 1 or 3 have to be addressed by
\code{<covariate>_<alternative>}.
If \code{standardize = "all"}, all covariates get standardized.}

\item{test_prop}{Either \code{NULL} or a numeric between 0 and 1. In the latter case, the data
is split into a training set (of decider proportion \code{1-test_prop}) and a
testing set (of decider proportion \code{test_prop}).}
}
\value{
An object of class \code{RprobitB_data}.
If \code{test_prop} is specified, a list of two \code{RprobitB_data} objects
labelled \code{"train"} and \code{"test"}.
}
\description{
This function prepares empirical choice data for the RprobitB package.
}
\details{
See the vignette "Data management" for more details:
\code{vignette("data_management", package = "RprobitB")}.
}
\examples{
data("Train", package = "mlogit")
data = prepare(form = choice ~ price | 0 | time + comfort + change,
               choice_data = Train, re = c("price","time"),
               standardize = "all")
}
