% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RprobitB_model.R
\name{RprobitB_model}
\alias{RprobitB_model}
\title{Create object of class \code{RprobitB_model}.}
\usage{
RprobitB_model(
  data,
  normalization,
  R,
  B,
  Q,
  latent_classes,
  prior,
  gibbs_samples,
  classification
)
}
\arguments{
\item{data}{An object of class \code{RprobitB_data}.}

\item{normalization}{An object of class \code{RprobitB_normalization}.}

\item{R}{The number of iterations of the Gibbs sampler.}

\item{B}{The length of the burn-in period, i.e. a non-negative number of samples to
be discarded.}

\item{Q}{The thinning factor for the Gibbs samples, i.e. only every \code{Q}th
sample is kept.}

\item{latent_classes}{Either \code{NULL} or a list of parameters specifying the number and the
latent classes:
\itemize{
\item \code{C}:
The number (greater or equal 1) of latent classes, which is set to 1 per
default and is ignored if \code{P_r = 0}.
If \code{update = TRUE}, \code{C} equals the initial number of classes.
\item \code{update}:
A boolean, determining whether to update \code{C}.
Ignored if \code{P_r = 0}.
If \code{update = FALSE}, all of the following elements are ignored.
\item \code{Cmax}:
The maximum number of latent classes.
\item \code{buffer}:
The updating buffer (number of iterations to wait before the next update).
\item \code{epsmin}:
The threshold weight for removing latent classes (between 0 and 1).
\item \code{epsmax}:
The threshold weight for splitting latent classes (between 0 and 1).
\item \code{distmin}:
The threshold difference in means for joining latent classes
(non-negative).
}}

\item{prior}{A named list of parameters for the prior distributions of the normalized
parameters:
\itemize{
\item \code{eta}:
The mean vector of length \code{P_f} of the normal prior for
\code{alpha}.
\item \code{Psi}:
The covariance matrix of dimension \code{P_f} x \code{P_f} of the
normal prior for \code{alpha}.
\item \code{delta}:
The concentration parameter of length 1 of the Dirichlet prior for
\code{s}.
\item \code{xi}:
The mean vector of length \code{P_r} of the normal prior for each
\code{b_c}.
\item \code{D}:
The covariance matrix of dimension \code{P_r} x \code{P_r} of the
normal prior for each \code{b_c}.
\item \code{nu}:
The degrees of freedom (a natural number greater than \code{P_r}) of
the Inverse Wishart prior for each \code{Omega_c}.
\item \code{Theta}:
The scale matrix of dimension \code{P_r} x \code{P_r} of the
Inverse Wishart prior for each \code{Omega_c}.
\item \code{kappa}:
The degrees of freedom (a natural number greater than \code{J-1}) of
the Inverse Wishart prior for \code{Sigma}.
\item \code{E}:
The scale matrix of dimension \code{J-1} x \code{J-1} of the
Inverse Wishart prior for \code{Sigma}.
}}

\item{gibbs_samples}{An object of class \code{RprobitB_gibbs_samples}.}

\item{classification}{The allocation variable of the estimated latent classes.}
}
\value{
An object of class \code{RprobitB_model}, i.e. a list with the arguments of
this function as elements.
}
\description{
This function creates an object of class \code{RprobitB_model}.
}
\keyword{s3}
