% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mailthreads.update.R
\name{mailthreads.update}
\alias{mailthreads.update}
\title{Update mail thread details}
\usage{
mailthreads.update(id, deal_id = NULL, shared_flag = NULL,
  read_flag = NULL, archived_flag = NULL, api_token = NULL,
  company_domain = "api", return_type = c("complete", "boolean"))
}
\arguments{
\item{id}{ID of the mail thread}

\item{deal_id}{ID of the deal this thread is associated with}

\item{shared_flag}{Whether this thread is shared with other users in your company This field has the following domains: (0; 1)}

\item{read_flag}{Whether this thread read or unread This field has the following domains: (0; 1)}

\item{archived_flag}{Whether this thread is archived or not. You can only archive threads that belong to Inbox folder. Archived threads will disappear from Inbox. This field has the following domains: (0; 1)}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}

\item{return_type}{the default return is an object List with all informations of process, or you can set boolean (TRUE = success, FALSE = error)}
}
\value{
customizable return, the default is an object List
}
\description{
Function to Update mail thread details on pipedrive.
}
\examples{
\donttest{
mailthreads.update(id='e.g.',api_token='token',company_domain='exp')
}
}
