% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/natom.R
\name{natom}
\alias{natom}
\alias{natom.coords}
\alias{natom.atoms}
\alias{natom.pdb}
\title{Number of Atoms in an Object Containing Atomic Coordinates}
\usage{
natom(x, ...)

\method{natom}{coords}(x, factor = NULL, ...)

\method{natom}{atoms}(x, factor = NULL, ATOM = TRUE, HETATM = TRUE, ...)

\method{natom}{pdb}(x, factor = NULL, ATOM = TRUE, HETATM = TRUE, ...)
}
\arguments{
\item{x}{an R object containing atomic coordinates.}

\item{\dots}{further arguments passed to or from other methods.}

\item{factor}{a factor used to split the object and evaluate the number of atoms
in each group.}

\item{ATOM}{a single element logical vector indicating if ATOM records have
to be considered or not.}

\item{HETATM}{a single element logical vector indicating if HETATM records
have to be considered or not.}
}
\value{
Return an integer or a vector of integer of lenght equal to 
  \code{nlevels(factor)} (if \code{factor} is specify) indication the number
  of atoms in the object or in the groups defined by \code{factor}.
}
\description{
Evaluates the number of atoms in an object containing atomic coordinates.
}
\details{
\code{natom} is a generic function to evalute the number of atom in an object
containing atomic coordinates. The atomic coordinates of the object are first
filtered to keep ATOM and/or HETATM records as indicated by the 'ATOM' and 
'HETATM' arguments. Then, if \code{factor} is specify, the object is splitted
to evalute the number of atoms in each group defined by \code{factor}. If 
\code{factor} is not specify then the total number of atoms in the object is 
return.
}
\examples{
x <- read.pdb(system.file("examples/PCBM_ODCB.pdb", package="Rpdb"))

natom(x)
natom(x, x$atoms$resid)
natom(x, x$atoms$resname)
natom(x, HETATM = FALSE)
  
}
\seealso{
\code{\link{coords}}, \code{\link{atoms}}, \code{\link{pdb}},
  \code{\link[base]{factor}}, \code{\link[base]{split}}
}
\keyword{manip}
