% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KF.R
\name{KF}
\alias{KF}
\title{The classical Kalman filter}
\usage{
KF(Y, mu_0, Sigma_0 = NULL, A, C, Sigma_Add, Sigma_Inn, epsilon = 1e-06)
}
\arguments{
\item{Y}{A list of matrices containing the observations to be filtered.}

\item{mu_0}{A matrix indicating the mean of the prior for the hidden states.}

\item{Sigma_0}{A matrix indicating the variance of the prior for the hidden states. It defaults to the limit of the variance of the Kalman filter.}

\item{A}{A matrix giving the updates for the hidden states.}

\item{C}{A matrix mapping the hidden states to the observed states.}

\item{Sigma_Add}{A positive definite matrix giving the additive noise covariance.}

\item{Sigma_Inn}{A positive definite matrix giving the innovative noise covariance.}

\item{epsilon}{A positive numeric giving the precision to which the limit of the covariance is to be computed. It defaults to 0.000001.}
}
\value{
An rkf S3 class.
}
\description{
The classical Kalman filter.
}
\examples{
library(RobKF)

set.seed(2019)

A = matrix(c(1), nrow = 1, ncol = 1)
C = matrix(c(1), nrow = 1, ncol = 1)

Sigma_Inn = diag(1,1)*0.01
Sigma_Add = diag(1,1)

mu_0 = matrix(0,nrow=1,ncol=1)

Y_list = Generate_Data(1000,A,C,Sigma_Add,Sigma_Inn,mu_0)

Output = KF(Y_list,mu_0,Sigma_0=NULL,A,C,Sigma_Add,Sigma_Inn)

plot(Output)

}
\references{
\insertRef{Kalman1960}{RobKF}
}
