% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{update.RoBSA}
\alias{update.RoBSA}
\title{Updates a fitted RoBSA object}
\usage{
\method{update}{RoBSA}(
  object,
  refit_failed = TRUE,
  formula = NULL,
  priors = NULL,
  test_predictors = "",
  distribution = NULL,
  model_weights = 1,
  prior_beta_null = get_default_prior_beta_null(),
  prior_beta_alt = get_default_prior_beta_alt(),
  prior_factor_null = get_default_prior_factor_null(),
  prior_factor_alt = get_default_prior_factor_alt(),
  prior_intercept = get_default_prior_intercept(),
  prior_aux = get_default_prior_aux(),
  chains = NULL,
  adapt = NULL,
  burnin = NULL,
  sample = NULL,
  thin = NULL,
  autofit = NULL,
  parallel = NULL,
  autofit_control = NULL,
  convergence_checks = NULL,
  save = "all",
  seed = NULL,
  silent = TRUE,
  ...
)
}
\arguments{
\item{object}{a fitted RoBSA object}

\item{refit_failed}{whether failed models should be refitted. Relevant only
if new priors or \code{prior_weights} are not supplied. Defaults to \code{TRUE}.}

\item{formula}{formula for the survival model}

\item{priors}{names list of prior distributions for each
predictor. It allows users to specify both the null and alternative
hypothesis prior distributions by assigning a named list
(with \code{"null"} and \code{"alt"} object) to the predictor}

\item{test_predictors}{vector of predictor names
to be tested with Bayesian model-averaged testing.
Defaults to \code{NULL}, no parameters are tested.}

\item{distribution}{a distribution of the new model.}

\item{model_weights}{either a single value specifying prior model weight
of a newly specified model using priors argument, or a vector of the
same length as already fitted models to update their prior weights.}

\item{prior_beta_null}{default prior distribution for the
null hypotheses of continuous predictors}

\item{prior_beta_alt}{default prior distribution for the
alternative hypotheses of continuous predictors}

\item{prior_factor_null}{default prior distribution for the
null hypotheses of categorical predictors}

\item{prior_factor_alt}{default prior distribution for the
alternative hypotheses of categorical predictors}

\item{prior_intercept}{named list containing prior
distribution for the intercepts (with names corresponding
to the distributions)}

\item{prior_aux}{named list containing prior
distribution for the auxiliary parameters (with names corresponding
to the distributions)}

\item{chains}{a number of chains of the MCMC algorithm.}

\item{adapt}{a number of adaptation iterations of the MCMC algorithm.
Defaults to \code{500}.}

\item{burnin}{a number of burnin iterations of the MCMC algorithm.
Defaults to \code{2000}.}

\item{sample}{a number of sampling iterations of the MCMC algorithm.
Defaults to \code{5000}.}

\item{thin}{a thinning of the chains of the MCMC algorithm. Defaults to
\code{1}.}

\item{autofit}{whether the model should be fitted until the convergence
criteria (specified in \code{autofit_control}) are satisfied. Defaults to
\code{TRUE}.}

\item{parallel}{whether the individual models should be fitted in parallel.
Defaults to \code{FALSE}. The implementation is not completely stable
and might cause a connection error.}

\item{autofit_control}{allows to pass autofit control settings with the
\code{\link[=set_autofit_control]{set_autofit_control()}} function. See \code{?set_autofit_control} for
options and default settings.}

\item{convergence_checks}{automatic convergence checks to assess the fitted
models, passed with \code{\link[=set_convergence_checks]{set_convergence_checks()}} function. See
\code{?set_convergence_checks} for options and default settings.}

\item{save}{whether all models posterior distributions should be kept
after obtaining a model-averaged result. Defaults to \code{"all"} which
does not remove anything. Set to \code{"min"} to significantly reduce
the size of final object, however, some model diagnostics and further
manipulation with the object will not be possible.}

\item{seed}{a seed to be set before model fitting, marginal likelihood
computation, and posterior mixing for reproducibility of results. Defaults
to \code{NULL} - no seed is set.}

\item{silent}{whether all print messages regarding the fitting process
should be suppressed. Defaults to \code{TRUE}. Note that \code{parallel = TRUE}
also suppresses all messages.}

\item{...}{additional arguments.}
}
\value{
\code{update.RoBSA} returns an object of class 'RoBSA'.
}
\description{
\code{update.RoBSA} can be used to
\enumerate{
\item{add an additional model to an existing \code{"RoBSA"} object by
specifying the distribution, and either null or alternative priors
for each parameter and prior weight of the model,}
\item{change the prior weights of fitted models by specifying a vector
\code{prior_weights} of the same length as the fitted models,}
\item{refitting models that failed to converge with updated settings
of control parameters,}
\item{or changing the convergence criteria and recalculating the ensemble
results by specifying new \code{control} argument and setting
\code{refit_failed == FALSE}.}
}
}
\details{
See \code{\link[=RoBSA]{RoBSA()}} for more details.
}
\seealso{
\code{\link[=RoBSA]{RoBSA()}}, \code{\link[=summary.RoBSA]{summary.RoBSA()}}, \code{\link[=prior]{prior()}}, \code{\link[=check_setup]{check_setup()}}
}
