% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctrynldata.R
\name{getCtryNlData}
\alias{getCtryNlData}
\title{Returns nightlight statistics for the given ctryCode and nlType in the given nPeriods}
\usage{
getCtryNlData(ctryCode, admLevel, nlTypes, nlPeriods,
  nlStats = pkgOptions("nlStats"), ignoreMissing = NULL,
  gadmVersion = pkgOptions("gadmVersion"), custPolyPath = NULL,
  downloadMethod = pkgOptions("downloadMethod"),
  cropMaskMethod = pkgOptions("cropMaskMethod"),
  extractMethod = pkgOptions("extractMethod"), source = "local", ...)
}
\arguments{
\item{ctryCode}{the ISO3 code of the country. Only 1 country can be 
processed at a time.}

\item{admLevel}{The country admin level of interest. Only 1 admLevel
can be processed at a time.}

\item{nlTypes}{a vector of nlTypes. The nightlight types to process.}

\item{nlPeriods}{a vector of nlPeriods. Must be appropriate nlPeriods
for the nlType.}

\item{nlStats}{a vector of nlStats. If not supplied defaults to all nlStats
as listed in pkgOptions("nlStats").}

\item{ignoreMissing}{controls how the function behaves if any data is not
found in the data file.

\itemize{
    \item NULL (default) only return data if found for ALL nlPeriods
       and ALL stats provided otherwise return NULL
    \item TRUE return any partial data that is found for the provided 
       nlPeriods and stats. Ignore any missing data
    \item FALSE return all data that is found and call \code{processNlData}
       to download and process any missing nlPeriods and stats
}}

\item{gadmVersion}{The GADM version to use}

\item{custPolyPath}{Alternative to GADM. A path to a custom shapefile zip}

\item{downloadMethod}{The method used to download polygons}

\item{cropMaskMethod}{The method used to crop and mask the satellite raster}

\item{extractMethod}{The method used to extract data and perform calculations
on the satellite raster}

\item{source}{"local" or "remote" Whether to download and process the
data locally or to download the pre-processed data from a remote 
source/repo}

\item{...}{other arguments}
}
\value{
dataframe of data for one country in one nlType in one or multiple
    nlPeriods
}
\description{
Returns nightlight data for the given ctryCode and nlStats in the given 
    nlPeriods and of the specified nlType. Note that getCtryNldata only
    processes one ctryCode at a time.
    \code{ignoreMissing} plays a significant role here. It can take 3 values:
    
    \itemize{
        \item NULL (default) only return data if found for all nlPeriods
           and all nlStats provided otherwise return NULL.
        \item TRUE return any partial data that is found for the provided 
           nlPeriods and nlStats. Ignore any missing data.
        \item FALSE return all data that is found and call \code{processNlData}
           to download and process any missing nlPeriods and nlStats.
    }
   
   Farther, if \code{nlPeriods} is missing, it is assigned values based on
   the value of ignoreMissing. If ignoreMissing is FALSE, nlPeriods is 
   assigned all existing nlPeriods to date. This is the equivalent of 
   retrieving all nightlight data for the given country and stats. If 
   ignoreMissing is TRUE or NULL then the existing data is returned.
}
\examples{
#NOTE: missing stats implies all stats as given by pkgOptions("nlStats")

#long running examples which also require large downloads
\dontrun{
getCtryNlData("KEN", "KEN_adm0", "VIIRS.M", ignoreMissing=NULL)
    #returns either all requested data if it exists i.e. all nlPeriods
    #and all nlStats for KEN otherwise NULL
}

\dontrun{
getCtryNlData("KEN", "KEN_adm0", "OLS.Y", ignoreMissing=TRUE)
    #Returns all requested data if it exists i.e. all nlPeriods and all
    #nlStats for KEN but omits any missing data
    }
 
\dontrun{
getCtryNlData(ctryCode="KEN", "KEN_adm0", "VIIRS.Y", ignoreMissing=FALSE)
    #Returns all requested data i.e. all nlPeriods and all
    #nlStats for KEN. All missing data will be downloaded and processed
    }
 
\dontrun{
getCtryNlData("KEN", "KEN_adm0", "VIIRS.M", nlPeriods=c("existingNlPeriod", "missingNlPeriod"),
    nlStats=c("sum", "unknownStat"), ignoreMissing=NULL)
    #Returns NULL due to missingNlPeriod and unknownStat not already existing
    #(ignoreMissing=NULL returns all data if exists or if any is missing returns NULL)
    }

\dontrun{
getCtryNlData("KEN", "KEN_adm0", "VIIRS.D", nlPeriods=c("existingNlPeriod", "missingNlPeriod"),
    nlStats=c("existingStat", "missingStat"), ignoreMissing=TRUE)
   #Returns existingStat for existingNlPeriods omits missingNlPeriod and missingStat
   #(ignoreMissing=TRUE returns only existing data)
   }
 
\dontrun{
getCtryNlData("KEN", "KEN_adm0", "VIIRS.M", nlPeriods=c("existingNlPeriod", "missingNlPeriod"),
    nlStats=c("sum", "unknownStat"), ignoreMissing=FALSE)
    #Runs processNlData for missingStat in "missingNlPeriod" and returns
    #"existingStat" and "missingStat" for both "existingNlPeriod" and
    #"missingNlPeriod"
    #(ignoreMissing=FALSE must return all data: forces processing of any missing)
    }
 
}
