% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctrynldata.R
\name{listCtryNlRasters}
\alias{listCtryNlRasters}
\title{List available cropped country rasters}
\usage{
listCtryNlRasters(ctryCodes = NULL, nlPeriods = NULL, nlTypes = NULL,
  source = "local")
}
\arguments{
\item{ctryCodes}{A character vector of ctryCodes to filter by}

\item{nlPeriods}{A character vector of nlPeriods to filter by}

\item{nlTypes}{A character vector of nlTypes to filter by}

\item{source}{Character string. Whether to check data availability
"local" or "remote". Default is "local".}
}
\value{
a list of existing cropped rasters
}
\description{
List available data. If source is "local" it lists data cached locally.
    If source is remote lists available data on the remote repository.
}
\examples{
#list all rasters
listCtryNlRasters()

#list all rasters available for KEN
listCtryNlRasters(ctryCodes = "KEN")

#list all VIIRS rasters available for ECU
listCtryNlRasters(ctryCodes = "ECU", nlTypes = "VIIRS")

#list available OLS rasters for KEN and RWA in 2012 & 2013
listCtryNlRasters(ctryCodes = c("KEN","RWA"), nlPeriods = c("2012", "2013"), nlTypes = "OLS.Y")

}
