% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal_Tests.R
\name{ADTest}
\alias{ADTest}
\title{Anderson-Darling Test}
\usage{
ADTest(data, alpha = 0.05, j = 1)
}
\arguments{
\item{data}{Data of a univariate distribution for which the test statistic is computed
(vector)}

\item{alpha}{The two-sided decision threshold used for hypothesis-testing}

\item{j}{The # hypotheses tested; used to compute a Bonferonni correction, if applicable;
should remain at its default if multiple testing is not an issue (scalar)}
}
\value{
An object including the test statistic, p-value, and a significance flag (list)
}
\description{
This function computes the one-sample Anderson-Darling test statistic and p-value
for fit to a normal distribution.
}
\details{
An adjusted statistic provided by D'agostino & Stephens (1986) is used,
where the mean and variance of the population are treated as unknown. D'agostino & Stephen's (1986)
text provides the equations used to obtain the function's p-values.
}
\examples{
values <- rnorm(100)
x <- ADTest(data = values)
}
\references{
D'agostino, R. B., & Stephens, M. A. (1986). Goodness-of-fit-techniques (Vol. 68). CRC press.
}
