% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ftsplot.r
\name{ftsplot}
\alias{ftsplot}
\title{Functional Time Series Plots}
\usage{
ftsplot(x, y, X, type = 2, zlab = NULL, xlab = NULL, ylab = NULL,
  space = 0.1, main = NULL)
}
\arguments{
\item{x}{a numeric vector of coordinate x.}

\item{y}{a numeric vector of coordinate y.}

\item{X}{a functional time series object of class \code{\link[fda]{fd}}.}

\item{type}{what type of plot should be drawn. Possible types are
"type=1" for ribbon3D plot with curtain, "type=2" for ribbon3D plot
 without curtain, "type=3" for image2D plot.}

\item{zlab}{The label of z axis.}

\item{xlab}{The label of x axis.}

\item{ylab}{The label of y axis.}

\item{space}{The amount of space (as a fraction of the average ribbon width) left between ribbons.}

\item{main}{The main title.}
}
\description{
Novel different type of plots to visualize the functional time series data objects.
}
\examples{
data("Callcenter")
library(fda)
D <- matrix(sqrt(Callcenter$calls),nrow = 240)
N <- ncol(D)
time <- 1:30
K <- nrow(D)
u <- seq(0,K,length.out =K)
d <- 22 #Optimal Number of basises
basis <- create.bspline.basis(c(min(u),max(u)),d)
Ysmooth <- smooth.basis(u,D,basis)
Y <- Ysmooth$fd

par(mar=c(2,1,2,2),mfrow=c(1,3))
ftsplot(u,time,Y[1:30],space = 0.4,type=1,ylab = "",xlab = "Day",main = "Typ1=1")
ftsplot(u,time,Y[1:30],space = 0.4,type=2,ylab = "",xlab = "Day",main = "Typ1=2")
ftsplot(u,time,Y[1:30],space = 0.4,type=3,ylab = "",xlab = "Day",main = "Typ1=3")
}
