cat.goftests <- function(x, props, type = "gsquare", logged = FALSE) {
  
  obs <- colTabulate(x)
  est <- props * dim(x)[1]
  if (type == "chisquare" ) {
    sta <- 2 * obs * log( obs / est)
  } else  sta <- (obs - est)^2 / est
  stat <- colsums(sta) 
  pvalue <- pchisq(stat, length(props) - 1, lower.tail = FALSE, log.p = logged )
  cbind(stat, pvalue)
}